block('b-edit-banner2').mod('type', 'text2')(

    elem('help-text').tag()('p'),

    elem('input-counter').tag()('span'),

    elem('nobr').tag()('span'),

    def()(function() {
        var ctx = this.ctx,
            banner = this.ctx.banner || {},
            group = this.ctx.group || {},
            campaign = this.ctx.campaign || {},
            vcard = banner.vcard || {},
            isImageAdEnabled = campaign.mediaType === 'text',
            modelParams = {
                name: 'm-banner',
                id: banner.modelId,
                parentName: 'm-group',
                parentId: group.modelId
            };

        return applyNext({
            'mods.with-vcard': ctx.withVCard ? 'yes' : '',
            'mods.for-banner-type': u.escapeHTML(banner.banner_type) || 'desktop',
            'mods.ad-type': u.beminize(u.escapeHTML(this.ctx.banner.ad_type) || 'text'),
            urlLengthLimit: this.ctx.urlLengthLimit,
            bannerIndex: this.ctx.index,
            canDelete: this.ctx.canDelete,
            banner: banner,
            group: group,
            campaign: campaign,
            errors: banner.errors || {},
            modelParams: modelParams,
            dmParams: modelParams,
            vcard: vcard,
            availableBannerCount: this.ctx.availableBannerCount,
            canEditDomain: this.ctx.canEditDomain && banner.ad_type != 'image-ad' && banner.ad_type != 'cpc_video',
            tagsProcessed: banner.tags ?
                Object.keys(banner.tags).reduce(function(result, tagId) {
                    var cTag = (campaign.tags || []).filter(function(tag) {
                        return tag.id === tagId;
                    }).pop();

                    return result.concat({
                        id: tagId,
                        value: cTag && cTag.value
                    });
                }, []) : [],
            isSingleGroup: this.ctx.isSingleGroup,
            isImageAdEnabled: isImageAdEnabled,
            promoCodeDomains: ctx.promoCodeDomains,
            organization: ctx.organization
        })
    }),

    js()(function() {
        return {
            clientId: this.campaign.ClientID,
            modelParams: this.modelParams,
            promoCodeDomains: this.promoCodeDomains
        };
    }),

    content()(function() {
        var banner = this.banner,
            randPhrase = u['dm-base-group'].getRandomActivePhrase(this.group.phrases || []),
            groupId = this.group.modelId,
            sitelinks = banner.sitelinks,
            organization = this.organization,
            isImageAdEnabled = this.isImageAdEnabled,
            adType = banner.ad_type,
            currentViewType = adType === 'image_ad' ?
                'base-image' :
                adType === 'cpc_video' ? 'creative' : 'edit',
            campMediaType = this.campaign.mediaType,
            banners = [u._.pick(banner, ['image', 'banner_type', 'creative', 'sitelinks'])],
            blockNameByType = u['b-banner-preview2'].getNameByType('text', currentViewType),
            isTurboLandingEnabled = this.ctx.isTurboLandingEnabled,
            isCreative = !u['b-image-add-loader'].isEmptyCreative(banner.creative),
            lang = this.ctx.lang,
            isFirst = this.bannerIndex === 0;

        return {
            elem: 'layout',
            mix: {
                block: 'b-layout-form',
                mods: { inner: 'yes' }
            },
            content: [
                {
                    block: 'b-edit-banner2',
                    elem: 'header',
                    elemMods: {
                        mode: !this.isSingleGroup && this.bannerIndex == 0 ?
                            'no-border' :
                            undefined
                    },
                    hasHeaderActions: this.ctx.hasHeaderActions,
                    withMobile: this.ctx.withMobile
                },
                {
                    block: 'b-layout-table',
                    mods: { layout: 'preview' },
                    content: {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                elemMods: { position: 'l' },
                                content: [
                                    {
                                        block: 'b-error-pretty-message',
                                        js: true,
                                        mods: { theme: 'classic' },
                                        mix: {
                                            block: 'b-edit-banner2',
                                            elem: 'pretty-errors-message'
                                        }
                                    },
                                    isImageAdEnabled && [
                                        {
                                            block: 'b-edit-banner2',
                                            elem: 'ad-type'
                                        },
                                        {
                                            block: 'b-edit-banner2',
                                            elem: 'image-ad',
                                            attrs: { 'data-err-path': isCreative ? 'creative' : 'image_ad' }
                                        }
                                    ],
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'title',
                                        attrs: { 'data-err-path': 'title' }
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'title-ext',
                                        attrs: { 'data-err-path': 'title_extension' }
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'body',
                                        attrs: { 'data-err-path': 'body' }
                                    },
                                    isFirst && {
                                        block: 'b-edit-banner2',
                                        elem: 'turbo-promo'
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'contacts-title'
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'href',
                                        elemMods: {
                                            visible: banner.has_site_enum || 'yes'
                                        },
                                        mix: [
                                            {
                                                block: 'b-edit-banner2',
                                                elem: 'model-field',
                                                js: {
                                                    name: 'has_site_enum',
                                                    type: 'mod',
                                                    block: 'b-edit-banner2',
                                                    elem: 'href',
                                                    modName: 'visible'
                                                }
                                            }
                                        ],
                                        attrs: { 'data-err-path': 'href' },
                                        banner: this.banner,
                                        canEditDomain: this.canEditDomain,
                                        modelParams: this.modelParams,
                                        urlLengthLimit: this.urlLengthLimit,
                                        promoCodeDomains: this.promoCodeDomains
                                    },
                                    Boolean(isTurboLandingEnabled) && {
                                        block: 'b-edit-banner2',
                                        elem: 'turbo-landings',
                                        mods: {
                                            'vcard-allowed': this.mods['ad-type'] === 'text' ? 'yes' : ''
                                        },
                                        clientId: this.campaign.ClientID,
                                        turbolanding: this.banner.turbolanding,
                                        turbolanding_href_params: this.banner.turbolanding_href_params,
                                        sitelinks: sitelinks,
                                        isNewGroup: this.ctx.isNewGroup
                                    }
                                ]
                            },
                            { elem: 'gap' },
                            {
                                elem: 'cell',
                                elemMods: { position: 'r' },
                                content: [
                                    {
                                        block: 'b-banner-viewer',
                                        js: {
                                            modelBannerParams: this.modelParams,
                                            modelCampaignParams: {
                                                name: 'm-campaign',
                                                id: this.campaign.cid
                                            }
                                        },
                                        mods: { 'current-view': currentViewType },
                                        mix: [{
                                            block: 'b-edit-banner2',
                                            elem: 'banner-viewer'
                                        }],
                                        content: [
                                            {
                                                elem: 'preview-filter',
                                                content: {
                                                    block: 'b-banner-preview-filter2',
                                                    mix: [{
                                                        block: 'b-banner-viewer',
                                                        elem: 'filter'
                                                    }],
                                                    tabList: u['b-banner-preview-filter2'].getTabsList({
                                                        strategySearchName: this.campaign.strategy.search.name,
                                                        dontShowYacontext: this.campaign.dontShowYacontext,
                                                        campMediaType: campMediaType,
                                                        banners: banners
                                                    }),
                                                    isPartnerAllFormatsEnabled: u['b-banner-preview-filter2']
                                                        .isPartnerAllFormatsEnabled({
                                                            campMediaType: campMediaType,
                                                            banners: banners
                                                        })
                                                }
                                            },
                                            {
                                                elem: 'banner',
                                                content: [
                                                    {
                                                        block: 'b-banner-preview2',
                                                        mods: { type: 'text', view: currentViewType },
                                                        data: u[blockNameByType].fromServer({
                                                            banner: banner,
                                                            group: this.group,
                                                            phrase: randPhrase,
                                                            campaign: this.campaign,
                                                            organization: organization
                                                        }),
                                                        modelsParams: {
                                                            dmsIds: {
                                                                bannerId: this.modelParams.id,
                                                                groupId: groupId,
                                                                phraseId: randPhrase && randPhrase.modelId
                                                            }
                                                        }
                                                    },
                                                    {
                                                        block: 'b-banner-preview2-warnings',
                                                        mods: { 'auto-check': 'yes' },
                                                        modelParams: this.modelParams
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                },
                this.ctx.withVCard && {
                    block: 'b-edit-banner2',
                    elem: 'vcard',
                    modelParams: this.modelParams,
                    isVCardOpen: this.banner.is_vcard_open,
                    attrs: { 'data-err-path': 'vcard' }
                },
                {
                    block: 'b-layout-table',
                    mods: { layout: 'preview' },
                    content: {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                elemMods: { position: 'l' },
                                content: [
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'underscore'
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'price',
                                        attrs: { 'data-err-path': 'banner_price' },
                                        modelParams: this.modelParams,
                                        lang: lang
                                    },
                                    {
                                        block: 'b-edit-banner2',
                                        elem: 'additions2',
                                        mediaType: this.campaign.mediaType
                                    }
                                ]
                            },
                            { elem: 'gap' },
                            {
                                elem: 'cell',
                                elemMods: { position: 'r' }
                            }
                        ]
                    }
                },
            ]
        };
    })
);
