BEM.DOM.decl({ block: 'b-edit-banner2', modName: 'type', modVal: 'text2' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            var modelParams = this.params.modelParams;

            this.groupModel = BEM.MODEL.getOrCreate({
                name: modelParams.parentName,
                id: modelParams.parentId
            });

            this.deleteBtn = this.findBlockOn('delete-btn', 'link');

            this.geoModel = BEM.MODEL.getOrCreate({
                name: 'm-geo-regions',
                id: modelParams.parentId,
                parentName: modelParams.parentName,
                parentId: modelParams.parentId
            });

            this.deleteBtn && this.deleteBtn.on('click', this._deleteBanner, this);

            this._imageAdLoader = this._initImageAdLoader();
            this._bannerViewer = this.findBlockOn('banner-viewer', 'b-banner-viewer');
            this._videoExtention = this.findBlockOn('addition-video-control', 'b-video-extension');
            this._turboLandingsSelector = this.findBlockInside('turbo-landings-control', 'b-turbo-landings-selector');
            this._turboLandingsParams = this.findBlockInside('turbo-landings-params-control', 'b-href-params');

            this._initAdditionEvents();

            this._bindModelEvents({ isBind: true });
            this._bindTogglers({ isBind: true });
            this._initHref();

            // Сбрасываем креатив (видео и графический) при изменении типа объявления,
            // т.к. для `image_ad` и `cpc_video` креатив задается в одном поле
            this.model.on('ad_type', 'change', function() {
                this.model.get('image_ad').clear();
                this.model.get('creative').clear();
            }, this);

            this._mobileCheckbox = this.findBlockOn('mobile-checkbox', 'checkbox');
            if (this._mobileCheckbox) {
                this._bindMobile();
            }

            this._geoRestrictionsRequest = BEM.blocks['i-mass-request-factory'].getInstanceFor('getGeoRestrictions');

            this._getGeoRestrictions();
        },

        'ad-type': function(modName, modVal) {
            switch (modVal) {
                case 'cpc-video':
                    this.elem('image-ad').attr('data-err-path', 'creative');
                    break;
                case 'image-ad':
                    this.elem('image-ad').attr('data-err-path', 'image_ad');
                    break;
            }

            this._imageAdLoader.updateItemStates();
        }
    },

    /**
     * Определяет все возможные медиадополнения для баннера
     * @param {Object} resources
     */
    setMediaResources: function(resources) {
        this._mediaExtensionsDataProvider = BEM.create('i-banner-media-extensions-data', { resources: resources });
    },

    /**
     * Привязывает тип объявления к состоянию чекбокса "Мобильное объявление"
     * Меняет текст подсказки возле адреса в соответствии с типом объявления
     */
    _bindMobile: function() {
        this._mobileCheckbox.on('change', function() {
            this.model.set('banner_type', this._mobileCheckbox.isChecked() ? 'mobile' : 'desktop');
        }, this);

        this.model.on('banner_type', 'change', function() {
            var bannerType = this.model.get('banner_type');

            this.setMod('for-banner-type', bannerType);

            this._mobileCheckbox.setMod('checked', bannerType === 'mobile' ? 'yes' : '');
        }, this);
    },

    /**
     * Добавляем события, по которым инициализируются внутренние блоки b-banner-sitelinks и b-banner-pic
     * Они инициализируются либо сами - при клике на кнопку "добавить", либо если кто-то извне изменяет их модель
     * @private
     */
    _initAdditionEvents: function() {
        this.model.get('image_model').on('change', function() {
            var additions = this.findBlockInside('additions', 'b-model-form-error');
            additions && additions.delMod('with-error');

            if (this._imageInited) return;

            this._imageInited = true;
            this.findBlockInside('b-banner-pic');
        }, this);

        this.model.get('sitelinks').on('change', function() {
            if (this._sitelinksInited) return;

            this._sitelinksInited = true;
            this.findBlockInside('b-banner-sitelinks');
        }, this);
    },

    /**
     * Удаление баннера
     * @private
     */
    _deleteBanner: function() {
        var handler = this._onRemoveRequest.bind(this);

        //если визитка не пустая - то даже если ее не меняли - покажем предупреждение
        if (this.model.isChanged() || !this._isVCardEmpty()) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-edit-banner2', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить объявление?'),
                onYes: handler
            }, this);
        } else {
            handler();
        }
    },

    _isVCardEmpty: function() {
        if (!this.hasMod('with-vcard', 'yes')) return true;

        return this.model.get('isVCardEmpty');
    },

    /**
     * Возвращает промис ограничения по паре текст/регионы
     * @returns {Object}
     * @private
     */
    _getGeoRestrictions: function() {
        var _this = this,
            text = this.model.get('body') + ' ' + this.model.get('title') + ' ' + this.model.get('title_extension'),
            adType = this.model.get('ad_type');

        if (adType === 'image_ad' || adType === 'cpc_video') {
            this._geoRestrictionsRequest.abort();

            this.model.trigger('geo-check-error', { messages: '' });

            return;
        }

        this._geoRestrictionsRequest.get({
            text: text,
            geo: this.geoModel.get('geo')
        }, function(data) {
            var warning;

            if (data.warning) {
                warning = data.warning;
            } else if (data.error) {
                warning = data.error.for_banner;
            }

            _this.model.trigger('geo-check-error', { messages: warning });
        }, function() {
            _this.model.trigger('geo-check-error', { messages: '' });
        });

        return this;
    },

    _bindModelEvents: function(options) {
        var actionName1 = options && options.isBind ? 'on' : 'un',
            actionName2 = options && options.isBind ? 'bindTo' : 'unbindFrom',
            narrowSymbols = u.consts('NARROW_SYMBOLS'),
            input;

        this.geoModel[actionName1]('change', this._getGeoRestrictions, this);

        this.model[actionName1]('title body', 'change', function() {
            if (!this.getFieldBlock('title').input.hasMod('focused') &&
                !this.getFieldBlock('body').input.hasMod('focused')) {
                this._getGeoRestrictions();
            }
        }, this);

        this[actionName2]('copy-from-prev', 'click', this._copyFromPrev);
        this[actionName2]('clear-text', 'click', this._clearText);

        input = this.getFieldBlock('title').input;
        input[actionName1]('change', function(e) {
            this._updateLengthCounter(
                'title',
                e.block.val(),
                +u.consts('NEW_MAX_TITLE_LENGTH'),
                ''
            );
        }, this);
        input[actionName1]('blur', function(e) {
            this._getGeoRestrictions();
        }, this);

        input = this.getFieldBlock('title_extension').input;
        input[actionName1]('change', function(e) {
            this._updateLengthCounter('title-ext', e.block.val(), u.consts('MAX_TITLE_EXTENSION_LENGTH'), narrowSymbols);
        }, this);
        input[actionName1]('blur', function(e) {
            this._getGeoRestrictions();
        }, this);

        input = this.getFieldBlock('body').input;
        input[actionName1]('change', function(e) {
            this._updateLengthCounter('body', e.block.val(), +u.consts('MAX_BODY_LENGTH'), narrowSymbols);
        }, this);
        input[actionName1]('blur', function(e) {
            this._getGeoRestrictions();
        }, this);

        this.model.get('ad_type') && this.model[actionName1]('ad_type', 'change', this._changeBannerAdType, this);

        this._bindAdditionalModelEvents(options);

        this._imageAdLoader && this._bindImageAdEvents(options);
        this._bindVideoExtensionEvents();

        return this;
    },

    /**
     * Подписывается/отписывается на дополнительные события модели
     * @param {Object} options
     * @private
     */
    _bindAdditionalModelEvents: function(options) {
        var actionName = options && options.isBind ? 'on' : 'un',
            input = this.getFieldBlock('display_href').input;

        input[actionName]('change', function(e) {
            this._updateLengthCounter('display-link', e.block.val(), 20, u.consts('NARROW_SYMBOLS'));
        }, this);
    },

    /**
     * Привязывает поведение переключалок "со ссылкой/с визиткой"
     * @param {Object} options
     * @param {Boolean} options.isBind
     * @returns {*}
     * @private
     */
    _bindTogglers: function(options) {
        var actionName1 = options && options.isBind ? 'on' : 'un';

        this.model[actionName1]('has_vcard', 'change', this._updateHrefRequired, this);

        if (this.hasMod('with-vcard')) {
            var vcard = this._vcard = this.findBlockInside('b-vcard-control');

            // когда кто-то меняет vcard нужно убирать ошибку href
            // однако в инит стадии vcard генерирует много событий change
            // поэтому вешаемся на change после инита
            vcard[actionName1]('ready', function() {
                vcard[actionName1]('change', this._clearHrefError, this);
            }, this);
        }

        return this;
    },

    /**
     * Проверяет, валиден ли данный блок
     * @returns {Boolean}
     */
    isValid: function() {
        return this.model.isValid() && this.groupModel.isValid();
    },

    /**
     * Обновляет значение счетчика оставшихся символов
     * @param {String} name
     * @param {String} val
     * @param {Number} limit
     * @param {String} narrowSymbols
     * @private
     */
    _updateLengthCounter: function(name, val, limit, narrowSymbols) {
        var counter = this.elem(name + '-length-counter'),
            counterValue;

        val = u.preview.skipSharpSign(val);

        if (name === 'title-ext' || name === 'title' || name === 'body') {
            counterValue = u.preview.strCounterWithoutNarrow(
                val,
                limit,
                narrowSymbols
            );
        } else {
            counterValue = limit - (val.length || 0);
        }

        counter.text(counterValue);

        this.toggleMod(counter, 'under-zero', 'yes', counterValue < 0);
    },

    /**
     * Инициализирует поле "Ссылка на сайт" у баннера
     * @private
     */
    _initHref: function() {
        this._updateHrefRequired();

        this._initPromoCodeCheck();
    },

    /**
     * Переключает видимость элемента "поле обязательно для заполнения" блока "ссылка на сайт"
     * @private
     */
    _updateHrefRequired: function() {
        var adType = this.model.get('ad_type'),
            //ссылка обязательна только если нет визитки
            hrefRequired = !this.model.get('has_vcard') || adType === 'image_ad' || adType === 'cpc_video';

        this.setMod(this.elem('href-required'), 'hidden', hrefRequired ? '' : 'yes');
        this.model.fields.href_model.get().set('required', hrefRequired, { isInit: true });
        !hrefRequired && this._clearHrefError();
    },

    /**
     * Проверяет заполненный ли это баннер
     * @param {Object} bannerData – данные баннера
     * @returns {Boolean}
     * @private
     */
    _isBannerFilled: function(bannerData) {
        var isNotEmpty = function(fields, obj) {
            return fields.some(function(field) { return obj[field] });
        };

        return isNotEmpty(['has_vcard', 'body', 'title'], bannerData) ||
            bannerData.image_model && bannerData.image_model.image ||
            bannerData.href_model && isNotEmpty(['domain', 'domain_redir', 'href'], bannerData.href_model) ||
            bannerData.sitelinks && isNotEmpty(['href0', 'href1', 'href2', 'href3'], bannerData.sitelinks) ||
            bannerData.image_ad && bannerData.image_ad.hash ||
            bannerData.creative && bannerData.creative.creative_id ||
            bannerData.video_resources && bannerData.video_resources.id;
    },

    /**
     * Апдейтит модель данными предыдущего баннера
     * @param {Object} e
     * @param {Object} opt
     * @param {Boolean} opt.vcardOnly - копировать только визитку
     */
    _copyFromPrev: function(e, opt) {
        var model = this.model,
            adType = model.get('ad_type'),
            modelId = model.get('modelId'),
            // если баннер уже был сохранен, то копировать нужно данные ближайшего баннера совпадающего по типу баннера
            // поле ad_type может отсутствовать (так как оно есть только у моделей тго и рмп баннеров)
            data = this.groupModel.getPrevBannerData(modelId, !model.get('isNewBanner') && adType ? adType : undefined),
            // если копируются только данные визитки, то нужно копировать данные
            // предыдыщего баннера с наличием поля модели визитки
            vcardData = (!opt || !opt.vcardOnly || !adType) ? data : this.groupModel.getPrevBannerData(modelId, 'text'),
            // копирует данные предыдущего баннера
            copyAction = function() {
                var deferred,
                    empty = !this._isBannerFilled(data),
                    hrefModel = model.get('href_model');

                // выставление режима копирования модели
                hrefModel.setCopyState(true);

                //для редактирования текстов баннеров, где нет визитки
                if (!this.hasMod('with-vcard') || empty) {
                    model.update(data);
                    // снятие режима копирования модели переехало в b-banner-href
                    //т.к. нужно проверять состояние моделей после пачки операций по таймауту

                    // если копируемая визитка не заполнена очищаем контактную информацию
                    empty && this._vcard.clear();

                    return;
                }

                if (!opt || !opt.vcardOnly) {
                    deferred = $.Deferred();

                    if (data.ad_type === 'image_ad' || data.ad_type === 'cpc_video') {
                        deferred.resolve();
                    } else {
                        this._vcard && this._vcard.fill(vcardData, deferred);
                    }

                    //апдейтим весь баннер только если не отменили копирование в визитке
                    deferred.done(function() {
                        model.update(data);
                        // снятие режима копирования модели переехало в b-banner-href
                        //т.к. нужно проверять состояние моделей после пачки операций по таймауту
                    }.bind());
                } else {
                    this._vcard && this._vcard.fill(vcardData);
                }
            }.bind(this);

        if (!this._isBannerFilled(data)) {
            BEM.blocks['b-confirm'].open({
                message: iget2(
                    'b-edit-banner2',
                    'predydushchiy-banner-ne-zapolnen',
                    'Предыдущий баннер не заполнен, при копировании текст текущего баннера будет удален'
                ),
                onYes: copyAction,
                textYes: iget2('b-edit-banner2', 'ok', 'OK'),
                textNo: iget2('b-edit-banner2', 'otmena', 'Отмена')
            }, this);
        } else {
            copyAction();
        }
    },

    /**
     * Очищает текст, ссылку и адрес в модели
     */
    _clearText: function() {
        this.model.update({
            title: '',
            title_extension: '',
            body: '',
            video_resources: {},
            callouts: [],
            display_href: '',
            banner_price: {
                price: '',
                priceOld: '',
                prefix: 'WITHOUT_PREFIX',
                currency: 'RUB',
            }
        });

        //метрика
        try {
            yaCounter191494.reachGoal('CLEAR_TEXT');
        } catch (e) { }

        this.model.get('image_model').clear();
        this.model.get('href_model').clear();
        this.model.get('sitelinks').clear();

        this.model.get('ad_type') && this.model.clear('ad_type');
        this.model.get('image_ad') && this.model.get('image_ad').clear();
        this.model.get('creative') && this.model.get('creative').clear();
        this.model.get('turbolanding') && this.model.get('turbolanding').clear();
        this._vcard && this._vcard.clear();
    },

    /**
     * Очищает ошибку href поля
     * @private
     */
    _clearHrefError: function() {
        this.findBlockOn(this.elem('pretty-errors-message', 'position', 'href'), 'b-error-pretty-message')
            .clearErrors();
    },

    /**
     * Меняет вид формы в соответсвии с выбранным типом объявления баннера
     * @private
     */
    _changeBannerAdType: function() {
        var adType = this.model.get('ad_type');

        this._updateHrefRequired();

        this.setMod('ad-type', u.beminize(adType));

        // Графическое объявление нельзя сделать мобильным
        // поэтому при переключении типа скрываем контрол галки 'Мобильное объявление'
        (adType === 'image_ad' || adType === 'cpc_video') && this.setMod('for-banner-type', 'desktop');

        this._bannerViewer.setMod(
            'current-view',
            adType === 'image_ad' ?
                'base-image' :
                adType === 'cpc_video' ? 'creative' : 'edit'
        );

        // для графических баннеров предупреждение о ограничении текст-регион показывать не нужно
        // поэтому текст ограничения нужно обновлять при смене типа баннера
        this._getGeoRestrictions();
    },

    /**
     * Передает внутренним блокам новое доступное для добавления количество баннеров
     * @param {Number} count - доступное для добавления количество баннеров
     */
    updateAvailableBannerCount: function(count) {
        this._imageAdLoader && this._imageAdLoader.updateAvailableBannerCount(count);
    },

    /**
     * Инициализирует контрол для загрузки графического объявления
     * @return {BEM.DOM<b-image-add-loader>|undefined} блок для загрузки файла изображения для графического объявления
     * @private
     */
    _initImageAdLoader: function() {

        var imageAdLoader = this.findBlockOn(this.elem('image-ad-loader'), 'b-image-add-loader');

        if (imageAdLoader) {
            imageAdLoader
                .on('_loading_*', this._onLoadingImages, this)
                .on('change:creatives', function(e, data) {
                    var href = data.href || {},
                        creatives = data.creatives || data.images;

                    if (data.images) {
                        this.model.clear('creative');
                        this.model.get('image_ad').update(data.images[0]);
                        this.elem('image-ad').attr('data-err-path', 'image_ad');
                    }

                    if (data.creatives) {
                        var firstCreative = data.creatives[0];

                        this.model.clear('image_ad');
                        this.model.get('creative').update(firstCreative);
                        this.elem('image-ad').attr('data-err-path', 'creative');
                    }

                    // если выбрано более 1 креатива, добавляем новые баннеры
                    if (creatives.length > 1) {
                        this.model.get('href_model').update({
                            href: href.href || '',
                            domain: href.href_domain || '',
                            url_protocol: href.protocol || ''
                        });

                        this.trigger(
                            'new:banners:needed',
                            creatives.slice(1).map(function(el) {
                                var newBannerData = { ad_type: 'image_ad' };

                                data.images && (newBannerData.image_ad = el);
                                data.creatives && (newBannerData.creative = el);

                                if (href.href) {
                                    newBannerData.href = href.href;
                                    newBannerData.domain = href.href_domain;
                                    newBannerData.url_protocol = href.protocol;
                                }

                                return newBannerData;
                            })
                        );
                    } else {
                        href.href && this.model.get('href_model').update({
                            href: href.href,
                            domain: href.href_domain,
                            url_protocol: href.protocol
                        });
                    }

                    if (data.errors) {
                        BEM.blocks['b-confirm'].open({
                            message: data.errors,
                            type: 'alert',
                            title: data.errors.length > 1 ?
                                iget2('b-edit-banner2', 'title-errors-upload-images', 'Следующие файлы не были загружены') :
                                iget2('b-edit-banner2', 'title-errors-upload-image', 'Файл не был загружен'),
                            withBullets: data.errors.length > 1
                        });
                    }
                }, this)
                .on('ready', function(e, data) {
                    var bannerStorage = data.bannerStorage,
                        bannerPreview2 = this.findBlockInside('b-banner-preview2');

                    if (bannerPreview2) {
                        bannerStorage.postMessage({
                            type: 'video-addition-preview',
                            data: u['b-banner-preview2'].getVideoPreviewPostMessage(bannerPreview2.getCtxData())
                        })
                    }
                }, this);
        }

        return imageAdLoader;
    },

    /**
     * Подписывается/отписывается на события модели графического объявления
     * @param {Object} options
     * @private
     */
    _bindImageAdEvents: function(options) {
        var actionName = options && options.isBind ? 'on' : 'un';

        this.model[actionName]('image_ad', 'clear', function() {
            this._imageAdLoader.resetImage();
        }, this);

        this.model[actionName]('image_ad', 'update', function() {
            this._imageAdLoader.setImage(this.model.get('image_ad').toJSON());
        }, this);

        this.model[actionName]('creative', 'update', function() {
            this._imageAdLoader.setCreative(this.model.get('creative').toJSON());
        }, this);
    }
});
