/**
 * @fires remove
 */
BEM.DOM.decl({ block: 'b-edit-banner2', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._initAdditionEvents();

            this._initIntegrableMeasures();
        }
    },

    onElemSetMod: {
        'measurer-field': {
            visible: function(elem, modName, modVal) {
                var input = this.findBlockInside(elem, 'input');

                if (input) {
                    input.setMod('disabled', modVal !== 'yes' ? 'yes' : '');
                }
            }
        },

        'measurer-integrable': {
            authorized: {
                unknown: function(elem) {
                    this._toggleLoadedMeasurer(elem, true);
                    this._toggleEditableMeasurer(elem, false);
                },

                yes: function(elem) {
                    this._toggleLoadedMeasurer(elem, false);
                    this._toggleEditableMeasurer(elem, true);
                },

                no: function(elem) {
                    this._toggleLoadedMeasurer(elem, false);
                    this._toggleEditableMeasurer(elem, false);
                }
            }
        }
    },

    /**
     * Передает внутренним блокам новое доступное для добавления количество баннеров
     * (переопределяется в модификаторах)
     * @param {Number} count - доступное для добавления количество баннеров
     */
    updateAvailableBannerCount: function(count) { },

    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        return this.__base.apply(this, arguments);
    },

    /**
     * Добавляем события, по которым инициализируются внутренние блоки b-banner-sitelinks и b-banner-pic
     * Они инициализируются либо сами - при клике на кнопку "добавить", либо если кто-то извне изменяет их модель
     * @private
     */
    _initAdditionEvents: function() {
        this.model.get('image_model') && this.model.get('image_model').on('change', function() {
            var additions = this.findBlockInside('additions', 'b-model-form-error');
            additions && additions.delMod('with-error');

            if (this._imageInited) return;

            this._imageInited = true;
            this.findBlockInside('b-banner-pic');
        }, this);

        this.model.get('sitelinks') && this.model.get('sitelinks').on('change', function() {
            if (this._sitelinksInited) return;

            this._sitelinksInited = true;
            this.findBlockInside('b-banner-sitelinks');
        }, this);
    },

    /**
     * Реакция на запрос удаления баннера
     */
    _onRemoveRequest: function() {
        this.trigger('remove', {
            model: this.model
        });
    },

    /**
     * Подписывается на события медиа-дополнений баннера (видео)
     * @private
     */
    _bindVideoExtensionEvents: function() {
        if (!this._videoExtention) {
            return;
        }

        this._subscriptionManager.wrap(this.model)
            // обрабатываем изменение видеодополнения
            .on('video_resources', 'change', function() {
                var videoResource = this.model.get('video_resources');

                if (videoResource.id) {
                    this._videoExtention.switchToEdit(videoResource);
                } else {
                    this._videoExtention.switchToAdd();
                }
            }, this)
            // обрабатываем изменение картинки
            .on('image_model', 'change', function(e, data) {
                var isImageChanged = data.field === 'image_model' || (data.fields || []).indexOf('image') !== -1;

                if (isImageChanged) {
                    this._videoExtention.updateImageFlag(!!this.model.get('image_model').get('image'));
                }
            }, this);

        this._subscriptionManager.wrap(this._videoExtention)
            // добавление видеодополнения
            .on('add', function(e, data) {
                this.model.set('video_resources', data);
            }, this)
            // нажатие на ссылку с названием видео
            .on('show', function() {
                this._bannerViewer.showBannerAllFormats({
                    activeTab: 'video',
                    clientId: this.params.clientId
                });
            }, this)
            // нажатие на кнопку удаления видеодополнения
            .on('delete', function() {
                this.model.clear('video_resources');
            }, this);
    },

    /**
     * Обработчик изменения модификатора loading b-image-add-loader
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onLoadingImages: function(e, data) {
        BEM.MODEL.getOne('b-edit-banner-add2').set('canAdd', !data.modVal);
        BEM.MODEL.get('b-image-add-loader').forEach(function(model) {
            model.set('needDisabled', !!data.modVal);
        });
    },

    /**
     * Инициализирует проверку ссылки на соответсвие промокоду, если он есть
     * @private
     */
    _initPromoCodeCheck: function() {
        var promoCodeDomains;

        if (this.params.promoCodeDomains === undefined || this.params.promoCodeDomains.length === 0) {
            return;
        }

        promoCodeDomains = this.params.promoCodeDomains.map(function(domain) {
            return domain.toLowerCase();
        });

        this.model.get('href_model').on('href','change', function(event, data) {
            var newDomain = u.extractDomain(this.model.get('href_model').get('href').toLowerCase().trim()),
                isPromoCodeDomain = u._.includes(promoCodeDomains, newDomain);

            this.setMod(this.elem('promo-code-warning'), 'hidden', isPromoCodeDomain || newDomain === '' ? 'yes' : '');
        }, this);
    },

    _initIntegrableMeasures: function() {
        this._checkIntegrableMeasures();

        this.bindToWin('focus', this._checkIntegrableMeasures);
    },

    _checkIntegrableMeasures: function() {
        var measurerElems = this.findElem('measurer-integrable');

        if (measurerElems.length) {
            this.setMod(measurerElems, 'authorized', 'unknown');

            u.measurers.getAuthorizedSystems(u.consts('ulogin'), this.params.clientId)
                .then(function(systems) {
                    measurerElems.each(function(index) {
                        var measurerElem = this.elemify(measurerElems.eq(index), 'measurer-integrable'),
                            measurerSystem = this.elemParams(measurerElem).measurer,
                            isAuthorized = u._.includes(systems, measurerSystem);

                        this.setMod(measurerElem, 'authorized', isAuthorized ? 'yes' : 'no');
                    }.bind(this));
                }.bind(this))
                .catch(function() {
                    this.setMod(measurerElems, 'authorized', 'no');
                }.bind(this))
        }
    },

    _toggleLoadedMeasurer: function(elem, isLoaded) {
        var container = this.findElem(elem, 'measurer-integrable-loader');

        container.length && BEM.DOM.update(
            container,
        isLoaded ?
                BEMHTML.apply({ block: 'spin', js: true, mods: { theme: 'gray-16', progress: 'yes' } }) :
                ''
        );
    },

    _toggleEditableMeasurer: function(elem, isEditable) {
        var checkbox = this.findBlockInside(elem, 'checkbox');

        checkbox && checkbox.setMod('disabled', isEditable ? '' : 'yes');
    }

});
