block('b-edit-group-2').elem('content-promotion-group-type-title')(

    match(function() {
        return !u.consts('rights').enableContentPromotion;
    }).def()(''),

    content()(function() {
        var ctx = this.ctx,
            selected = ctx.selected || u['content-promotion'].getDefaultContentType(),
            dictionary = {},
            needSelect;

        if (u.consts('rights').enableContentPromotionVideo) {
            dictionary.video = iget2('b-edit-group-2', 'group-type-content-promotion-video', 'Яндекс.Видео');
        }
        if (u.consts('rights').enableContentPromotionCollection) {
            dictionary.collection = iget2('b-edit-group-2', 'group-type-cpm-video', 'Яндекс.Коллекции');
        }

        needSelect = !ctx.campaignHasGroups &&
            (ctx.isNewGroup || ctx.isCopyGroup) &&
            Object.keys(dictionary).length > 1;

        return [
            iget2('b-edit-group-2', 'content-promotion-group-type', 'Площадка размещения контента'),
            ':&nbsp;',
            needSelect ?
                {
                    block: 'select2',
                    mods: {
                        type: 'radio',
                        theme: 'transparent',
                        size: 'xl',
                        text: 'vary',
                        disabled: ctx.isCopyGroup ? 'yes' : undefined
                    },
                    mix: {
                        block: 'b-edit-group-2',
                        elem: 'content-promotion-group-type-selector'
                    },
                    val: selected,
                    items: u._.compact([
                        {
                            val: 'video',
                            text: dictionary.video
                        },
                        u.consts('rights').enableContentPromotionCollection && {
                            val: 'collection',
                            text: dictionary.collection
                        }
                    ])
                } :
                dictionary[selected]
        ];
    })
);
