block('b-edit-group-2').elem('cpm-group-type-title')(

    match(function() {
        return !u.consts('rights').allowedCpmVideoBanners;
    }).def()(''),

    content()(function() {
        var ctx = this.ctx,
            selected = ctx.selected || 'cpm_banner',
            dictionary = {},
            needSelect = ctx.isNewGroup || ctx.isCopyGroup;

        dictionary.cpm_banner = dictionary.cpm_deals = iget2('b-edit-group', 'group-type-cpm-banner', 'баннеры');
        dictionary.cpm_video = dictionary.cpm_video_deals = iget2('b-edit-group', 'group-type-cpm-video', 'видео');
        dictionary.cpm_outdoor = dictionary.cpm_outdoor_deals = iget2('b-edit-group', 'group-type-cpm-outdoor', 'наружная реклама');
        dictionary.cpm_indoor = dictionary.cpm_outdoor_deals = iget2('b-edit-group', 'group-type-cpm-indoor', 'внутренняя реклама');
        dictionary.cpm_audio = dictionary.cpm_audio = iget2('b-edit-group', 'group-type-cpm-audio', 'аудио');
        dictionary.cpm_geoproduct = iget2('b-edit-group', 'group-type-cpm-metro', 'баннер в Яндекс.Метро');

        if (!needSelect) {
            var beta = {
                block: 'b-beta',
                mods: { type: 'symbol' },
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'cpm-group-type-title-beta'
                }
            };
        }

        return u.spacer([
            iget2('b-edit-group-2', 'cpm-adgroup-type', 'Тип объявлений'),
            [
                needSelect ?
                    {
                        block: 'select2',
                        mods: {
                            type: 'radio',
                            theme: 'transparent',
                            size: 'xl',
                            text: 'vary',
                            disabled: ctx.isCopyGroup ? 'yes' : undefined
                        },
                        mix: {
                            block: 'b-edit-group-2',
                            elem: 'cpm-group-type-selector'
                        },
                        val: selected,
                        items: u._.compact([
                            {
                                val: 'cpm_banner',
                                text: dictionary['cpm_banner']
                            },
                            u.consts('rights').allowedCpmVideoBanners && {
                                val: 'cpm_video',
                                text: dictionary['cpm_video']
                            },
                            u.consts('rights').cpmAudioEnabled && {
                                val: 'cpm_audio',
                                text: dictionary['cpm_audio']
                            },
                            {
                                val: 'cpm_outdoor',
                                text: dictionary['cpm_outdoor']
                            },
                            {
                                val: 'cpm_indoor',
                                text: dictionary['cpm_indoor']
                            },
                            u.consts('rights').cpmGeoProductEnabled && {
                                val: 'cpm_geoproduct',
                                elemMods: { with: 'beta' },
                                text: dictionary['cpm_geoproduct']
                            }
                        ])
                    } :
                    dictionary[selected],
                {
                    block: 'b-help-link',
                    mix: {
                        block: 'b-edit-group-2',
                        elem: 'help-link'

                    },
                    mods: { type: 'modal' },
                    stretched: true,
                    icon: 'question',
                    url: u.getHelpUrl('cpm-campaign-ad-group-type')
                }
            ]
        ], ':&nbsp;');
    })
);
