block('b-edit-group-2').elem('display-conditions')(

    def()(function() {
        var selected = this.ctx.selected,
            availableConditions = u.campaign.getCpmGroupDisplayConditions(this.ctx.cpmGroupType || 'cpm_banner'),
            dictionary = {
                crypta: iget2('b-edit-group-2', 'pokaz-interesy-i-socdem', 'интересы и соцдем'),
                keywords: iget2('b-edit-group-2', 'pokaz-kljuchevye-frazy', 'ключевые фразы')
            };

        return {
            mixes: {
                row: [
                    {
                        block: 'b-edit-group-2',
                        elem: 'row',
                        elemMods: {
                            theme: 'grey',
                            type: 'display-conditions'
                        }
                    }
                ],
                control: [{
                    block: 'b-edit-group-2',
                    elem: 'control'
                }]
            },
            control: [
                {
                    block: 'b-edit-group-2',
                    elem: 'display-conditions-title',
                    content: u.spacer([
                        iget2('b-edit-group-2', 'uslovija-pokaza', 'Условия показа'),
                        [
                            this.ctx.isNewGroup || this.ctx.isCopyGroup ?
                                {
                                    block: 'select2',
                                    mods: {
                                        type: 'radio',
                                        theme: 'transparent',
                                        size: 'xl',
                                        text: 'vary',
                                        disabled: availableConditions.length < 2 ? 'yes' : ''
                                    },
                                    mix: {
                                        block: 'b-edit-group-2',
                                        elem: 'display-conditions-selector'
                                    },
                                    val: selected,
                                    items: [
                                        {
                                            val: 'crypta',
                                            text: dictionary['crypta']
                                        },
                                        {
                                            val: 'keywords',
                                            text: dictionary['keywords']
                                        }
                                    ]
                                } :
                                dictionary[selected],
                            {
                                block: 'b-help-link',
                                mix: {
                                    block: 'b-edit-group-2',
                                    elem: 'help-link'

                                },
                                mods: { type: 'modal' },
                                stretched: true,
                                icon: 'question',
                                url: u.getHelpUrl('cpm-campaign-impression-criteria')
                            }
                        ]
                    ], ':&nbsp;')
                }
            ]
        };
    })

);
