block('b-edit-group-2').elem('limit-rate').def()(function() {
    var ctx = this.ctx;

    return {
        attrs: {
            row: { 'data-err-path': this.ctx.errPath }
        },
        mixes: {
            row: [
                {
                    block: 'b-edit-group-2',
                    elem: 'row',
                    elemMods: {
                        theme: 'grey',
                        type: 'limit-rate'
                    }
                }
            ],
            label: [{
                block: 'b-edit-group-2',
                elem: 'label'
            }],
            info: [{
                block: 'b-edit-group-2',
                elem: 'info'
            }],
            control: [{
                block: 'b-edit-group-2',
                elem: 'control'
            }]
        },
        label: ctx.labelContent || [
            ctx.labelText || iget2('b-edit-group-2', 'maksimalnaya-stavka-dlya', 'Максимальная ставка для новых и измененных условий показа'),
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                stretched: true,
                mix: [{
                    block: 'b-edit-group-2',
                    elem: 'help-icon'
                }],
                url: u.getHelpUrl(ctx.helpLinkId || 'maximum-bid')
            }
        ],
        control: [
            {
                block: 'b-edit-phrase-price',
                mods: {
                    'control-type': 'general-limit',
                    'real-time': this.ctx.realTime || 'yes',
                    multiedit: 'yes'
                },
                mix: [
                    {
                        block: 'b-edit-group-2',
                        elem: 'general-limit-price'
                    },
                    {
                        block: 'b-errors-presenter2',
                        elem: 'cleaner',
                        js: { block: 'b-edit-phrase-price' }
                    }
                ],
                price: ctx.price,
                campDMParams: ctx.campDMParams,
                popupDirections: ['bottom', 'top'],
                currency: ctx.currency
            },
            {
                block: 'b-edit-group-2',
                elem: 'general-limit-price-description',
                content: iget2('b-edit-group-2', 'currency-valyuta-za-target', '{currency} за {target}', {
                    currency: u.currencies.getName(ctx.currency),
                    target: ctx.targetText || iget2('b-edit-group-2', 'klik', 'клик'),
                    context: 'currency - валюта; target - клик/показы'
                })
            },
            {
                block: 'b-error-pretty-message',
                js: true,
                mods: { theme: 'classic' },
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'pretty-errors-message'
                }
            },
            {
                block: 'b-edit-group-2',
                elem: 'general-limit-price-warnings'
            }
        ]
    };
});
