block('b-edit-group-2').elem('minus-words').def()(function() {
    var modelName = this.ctx.modelName || 'm-group';

    return {
        mixes: {
            row: {
                block: 'b-edit-group-2',
                elem: 'row',
                elemMods: {
                    type: 'minus-words'
                }
            }
        },
        attrs: {
            row: { 'data-err-path': this.ctx.errPath }
        },
        label: this.ctx.title || iget2('b-edit-group-2', 'minus-frazy-na-gruppu', 'Минус-фразы на группу'),
        control: applyCtx([
            {
                block: 'b-error-pretty-message',
                js: true,
                mods: { theme: 'classic' },
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'pretty-errors-message'
                }
            },
            {
                block: 'b-minus-words-control',
                mods: this.ctx.minusWordsMods,
                mix: {
                    block: 'b-errors-presenter2',
                    elem: 'cleaner',
                    js: { block: 'b-minus-words-control', event: 'save-click' }
                },
                for: 'groups',
                showPreview: true,
                modelParams: {
                    name: modelName,
                    id: this.group.modelId
                },
                requestParams: {
                    for: 'groups',
                    cid: this.data.campaign.cid,
                    adgroupId: this.group.modelId,
                    ulogin: this.data.FORM.ulogin
                },
                minusWords: this.group.minus_words
            }
        ])
    };
});
