block('b-edit-group-2').elem('new-phrases').def()(function() {
    return {
        attrs: {
            row: { 'data-err-path': this.ctx.errPath }
        },
        mixes: {
            row: [
                {
                    block: 'b-edit-group-2',
                    elem: 'row',
                    elemMods: {
                        type: 'new-phrases'
                    }
                },
                {
                    block: 'b-errors-presenter2',
                    elem: 'cleaner',
                    js: { block: 'b-group-add-phrases', event: 'phrases-block-change' }
                },
                {
                    block: 'b-group-add-phrases',
                    modelParams: {
                        name: this.ctx.modelName || 'm-group',
                        id: this.group.modelId
                    },
                    mods: {
                        suggestions: this.ctx.showSuggestions ? 'on' : 'off'
                    },
                    js: {
                        id: 'new_phrases_' + this.group.modelId,
                        modelParams: {
                            name: this.ctx.modelName || 'm-group',
                            id: this.group.modelId
                        }
                    }
                },
                {
                    block: 'b-group-edit-phrases',
                    js: {
                        adgroupId: this.group.modelId,
                        modelName: this.ctx.modelName || 'm-group'
                    }
                }
            ],
            label: [{
                block: 'b-edit-group-2',
                elem: 'label'
            }],
            control: [{
                block: 'b-edit-group-2',
                elem: 'control'
            }]
        },
        label: {
            block: 'b-group-add-phrases',
            elem: 'splited-label',
            content: [
                iget2('b-edit-group-2', 'novye-klyuchevye-frazy', 'Новые ключевые фразы'),
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    mix: [{
                        block: 'b-edit-group-2',
                        elem: 'help-icon'
                    }],
                    stretched: true,
                    url: u.getHelpUrl('add-keywords'),
                    title: iget2('b-edit-group-2', 'kak-pravilno-podbirat-klyuchevye', 'Как правильно подбирать ключевые фразы?')
                },
                {
                    block: 'button',
                    mix: [{
                        block: 'b-group-edit-phrases',
                        elem: 'phrases-list-btn',
                        elemMods: {
                            type: 'new'
                        }
                    }],
                    mods: {
                        theme: 'normal',
                        size: 'xs'
                    },
                    content: iget2('b-edit-group-2', 'spisok', 'список...')
                }
            ]
        },
        control: [
            {
                tag: 'a',
                attrs: {
                    id: 'add-phrase'
                }
            },
            {
                block: 'b-error-pretty-message',
                js: true,
                mods: {
                    theme: 'classic',
                    toggleable: 'yes'
                },
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'pretty-errors-message'
                }
            },
            applyCtx({
                block: 'b-group-add-phrases',
                elem: 'new-phrases-block',
                adgroupId: this.group.modelId,
                modelName: this.ctx.modelName,
                campaignModelName: this.ctx.campaignModelName
            })
        ]
    };
});
