block('b-edit-group-2').elem('outdoor').def()(function() {
    var ctx = this.ctx,
        platforms = [],
        selected = (ctx.selected || []).map(function(platform) {
            return platform.imp_id + '-' + platform.page_id;
        });

    (ctx.allOutdoorPlacements || []).forEach(function(provider) {
        (provider.blocks || []).forEach(function(platform) {
            if (platform.coordinates && /^(\-?\d+(\.\d+)?),\s*(\-?\d+(\.\d+)?)$/m.test(platform.coordinates)) {
                platforms.push({
                    provider: provider.caption,
                    caption: platform.address,
                    blockId: platform.blockId,
                    pageId: platform.pageId,
                    id: platform.blockId + '-' + platform.pageId,
                    resolution: platform.resolution.width + '×' + platform.resolution.height,
                    coordinates: platform.coordinates.split(',').map(Number)
                });
            }
        })
    });

    return {
        attrs: {
            row: { 'data-err-path': ctx.errPath }
        },
        mixes: {
            row: [
                {
                    block: 'b-edit-group-2',
                    elem: 'row',
                    elemMods: {
                        theme: 'grey',
                        type: 'outdoor'
                    }
                }
            ],
            label: [{
                block: 'b-edit-group-2',
                elem: 'label'
            }],
            info: [{
                block: 'b-edit-group-2',
                elem: 'info'
            }],
            control: [{
                block: 'b-edit-group-2',
                elem: 'control',
                elemMods: {
                    type: 'outdoor'
                }
            }]
        },
        label: [
            iget2('b-edit-group-2', 'advertising-platforms', 'Рекламные поверхности')
        ],
        control: [
            {
                block: 'b-error-pretty-message',
                js: true,
                mods: { theme: 'classic' },
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'pretty-errors-message'
                }
            },
            {
                block: 'b-edit-group-2',
                elem: 'warning-outdoor-group'
            },
            {
                block: 'b-outdoor-map',
                mix: [
                    {
                        block: 'b-errors-presenter2',
                        elem: 'cleaner',
                        js: { block: 'b-outdoor-map', event: 'save' }
                    },
                    {
                        block: 'b-edit-group-2',
                        elem: 'outdoor-map'
                    }
                ],
                js: {
                    platforms: platforms,
                    selected: selected,
                    campDMParams: this.ctx.campDMParams,
                    modelParams: this.ctx.modelParams
                },
                platforms: platforms,
                selected: selected
            }
        ]
    };

});
