block('b-edit-group-2').elem('relevance-match').def()(function() {
    var modelName = this.ctx.modelName || 'm-group',
        isRelevanceMatchOn = this.group['relevance_match'] && this.group['relevance_match'].length > 0,
        relevanceMatchText = isRelevanceMatchOn ? iget2('b-edit-group-2', 'da', 'Да') : iget2('b-edit-group-2', 'net', 'Нет');

    return {

        label: applyCtx({
            block: 'b-model-form-error',
            mix: [
                {
                    block: 'b-model-form-error',
                    elem: 'label'
                },
                {
                    block: 'b-feature-marker',
                    js: {
                        featureId: 'autotargeting',
                        helpUrl: u.getCommonHelpUrl('/direct/features/autotargeting.html'),
                        text: iget2('b-edit-group-2', 'relevance-match-feature-marker-text', 'Показывайте объявление по релевантным запросам на поиске и по интересам пользователя в сетях. Рекомендуется использовать автотаргетинг вместе с ключевыми фразами.')
                    }
                }
            ],
            modelName: modelName,
            modelId: this.group.modelId,
            field: 'has_relevance_match',
            errors: this.errors['relevance_match'],
            content: [
                iget2('b-edit-group-2', 'ispolzovat-avtotargeting', 'Использовать автотаргетинг'),
                {
                    block: 'b-help-link',
                    mods: { type: 'modal' },
                    stretched: true,
                    mix: [
                        { block: 'b-edit-group-2', elem: 'help-icon' },
                        { block: 'b-edit-group-2', elem: 'relevance-match-help' }
                    ],
                    url: u.getHelpUrl('autotargeting'),
                    title: iget2('b-edit-group-2', 'chto-takoe-avtotargeting', 'Что такое автотаргетинг?')
                }
            ]
        }),
        control: this.ctx.readOnly ?
            relevanceMatchText :
            applyCtx([
                {
                    block: 'b-model-form-error',
                    mix: [{ block: 'b-model-form-error', elem: 'control' }],
                    modelName: modelName,
                    modelId: this.group.modelId,
                    field: 'has_relevance_match',
                    errors: this.errors['has_relevance_match']
                },
                {
                    block: 'tumbler',
                    name: 'relevance_match',
                    mods: {
                        size: 's',
                        checked: isRelevanceMatchOn ? 'yes' : ''
                    },
                    mix: { block: 'b-edit-group-2', elem: 'relevance-match-tumbler' },
                    leftText: iget2('b-edit-group-2', 'da', 'Да'),
                    rightText: iget2('b-edit-group-2', 'net', 'Нет')
                }
            ])
    };
});
