block('b-edit-group-2').elem('retargeting').def()(function() {
    var allRetargetingConditions = u.retargeting
            .filterConditionsByType(this.data.all_retargeting_conditions, 'metrika_goals'),
        retargetings = u.retargeting.filterGroupConditionsByType(
            this.group.retargetings || [],
            this.data.all_retargeting_conditions,
            'metrika_goals'
        );

    return {
        attrs: {
            row: { 'data-err-path': this.ctx.errPath }
        },
        mixes: {
            row: {
                block: 'b-edit-group-2',
                elem: 'row',
                elemMods: {
                    type: 'retargeting'
                }
            }
        },
        label: [
            iget2('b-edit-group-2', 'usloviya-podbora-auditorii', 'Ретаргетинг и подбор аудитории'),
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                mix: [{
                    block: 'b-edit-group-2',
                    elem: 'help-icon'
                }],
                stretched: true,
                url: u.getHelpUrl('retargeting-impressions'),
                title: iget2('b-edit-group-2', 'zachem-nuzhny-usloviya-podbora', 'Зачем нужны условия подбора аудитории?')
            }
        ],

        control: [
            {
                block: 'b-error-pretty-message',
                js: true,
                mods: { theme: 'classic' },
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'pretty-errors-message'
                }
            },
            applyCtx({
                block: 'b-group-retargeting2',
                mods: {
                    type: retargetings.length ? 'edit' : 'add'
                },
                mix: [
                    {
                        block: 'b-edit-group-2',
                        elem: 'outboard-control'
                    },
                    {
                        block: 'b-errors-presenter2',
                        elem: 'cleaner',
                        js: {
                            block: 'b-group-retargeting2',
                            event: 'conditions:update'
                        }
                    }
                ],
                conditions: u.retargeting.transformServerData(allRetargetingConditions),
                selectedConditions: retargetings.map(function(condition) {

                    return {
                        ret_cond_id: condition.ret_cond_id,
                        ret_id: condition.ret_id,
                        condition_name: condition.condition_name,
                        is_accessible: allRetargetingConditions[condition.ret_cond_id].is_accessible
                    };
                })
            })
        ]
    };
});
