block('b-edit-group-2').elem('video-goals-control')(
    content().match(function() {
        var cpmGroupType = this.ctx.cpmGroupType,
            isIndoorSegmentsEnabled = this.ctx.isIndoorSegmentsEnabled;

        return cpmGroupType === 'cpm_video' || cpmGroupType === 'cpm_outdoor' || (cpmGroupType === 'cpm_indoor' && isIndoorSegmentsEnabled ) || cpmGroupType === 'cpm_audio';
    })(function() {
        var ctx = this.ctx,
            videoGoalsTypes,
            selected = u._.groupBy(ctx.selected, 'type'),
            text = {
                start: iget2('b-edit-group-2', 'video-goal-start', 'Показ'),
                first_quartile: iget2('b-edit-group-2', 'video-goal-quarter', '{quarter}\% досмотр', { quarter: 25 }),
                midpoint: iget2('b-edit-group-2', 'video-goal-quarter', '{quarter}\% досмотр', { quarter: 50 }),
                third_quartile: iget2('b-edit-group-2', 'video-goal-quarter', '{quarter}\% досмотр', { quarter: 75 }),
                complete: iget2('b-edit-group-2', 'video-goal-quarter', '{quarter}\% досмотр', { quarter: 100 })
            };

        switch (ctx.cpmGroupType) {
            case 'cpm_outdoor':
                videoGoalsTypes = u.consts('OUTDOOR_GOALS_AUDITORY_TYPES') || [];
                break;
            case 'cpm_indoor':
                videoGoalsTypes = u.consts('INDOOR_GOALS_AUDITORY_TYPES') || [];
                break;
            case 'cpm_audio':
                videoGoalsTypes = u.consts('AUDIO_GOALS_AUDITORY_TYPES') || [];
                break;
            default:
                videoGoalsTypes = u.consts('VIDEO_GOALS_AUDITORY_TYPES') || [];
        }

        return [
            {
                block: 'b-error-pretty-message',
                js: true,
                mods: { theme: 'classic' },
                mix: {
                    block: this.block,
                    elem: 'pretty-errors-message'
                }
            }
        ].concat(videoGoalsTypes.map(function(type) {
            return {
                block: 'checkbox',
                mods: {
                    checked: u._.isEmpty(selected[type]) ? '' : 'yes'
                },
                mix: [
                    {
                        block: this.block,
                        elem: 'video-goal-checkbox'
                    },
                    {
                        block: 'b-errors-presenter2',
                        elem: 'cleaner',
                        js: { block: 'checkbox' }
                    }
                ],
                checkboxAttrs: {
                    value: type
                },
                text: text[type]
            };
        }, this));
    })
);
