block('b-edit-group-2').elem('video-goals-label')(
    content().match(function() {
        var cpmGroupType = this.ctx.cpmGroupType,
            isIndoorSegmentsEnabled = this.ctx.isIndoorSegmentsEnabled;

        return cpmGroupType === 'cpm_video' || cpmGroupType === 'cpm_outdoor' || (cpmGroupType === 'cpm_indoor' && isIndoorSegmentsEnabled) || cpmGroupType === 'cpm_audio';
    })(function() {
        var labelOfAudienceGoals, urlId;

        switch (this.ctx.cpmGroupType) {
            case 'cpm_outdoor':
                labelOfAudienceGoals = iget2('b-edit-group-2', 'ya-audience-outdoor-goals', 'Сбор аудитории наружной рекламы');
                urlId = 'cpm-campaign-outdoor-audience';
                break;

            case 'cpm_indoor':
                labelOfAudienceGoals = iget2('b-edit-group-2', 'ya-audiencу-indoor-goals', 'Сбор аудитории внутренней рекламы');
                urlId = 'cpm-campaign-indoor-audience';
                break;

            case 'cpm_audio':
                labelOfAudienceGoals = iget2('b-edit-group-2', 'ya-audience-audio-goals', 'Сбор аудитории аудио');
                urlId = 'cpm-campaign-audio-audience';
                break;
            default:
                labelOfAudienceGoals = iget2('b-edit-group-2', 'ya-audience-video-goals', 'Сбор аудитории видео');
                urlId = 'cpm-campaign-video-audience';
        }

        return [
            labelOfAudienceGoals,
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                mix: [{
                    block: this.block,
                    elem: 'help-icon'
                }],
                stretched: true,
                url: u.getHelpUrl(urlId)
            }
        ];
    })
);
