block('b-edit-group-2').elem('video-goals')(
    def()(''),

    def().match(function() {
        var group = this.ctx.group;

        return (group.cpmGroupType === 'cpm_video' || group.cpmGroupType === 'cpm_outdoor' || (group.cpmGroupType === 'cpm_indoor' && hasEnabledFeatures('indoor_segments')) || group.cpmGroupType === 'cpm_audio') ||
            group.isNewGroup && (u.consts('rights').allowedCpmVideoBanners || u.consts('rights').cpmAudioEnabled);
    })(function() {
        var group = this.ctx.group,
            isIndoorSegmentsEnabled = hasEnabledFeatures('indoor_segments');

        return {
            attrs: {
                row: { 'data-err-path': 'video-goals' }
            },
            mixes: {
                row: [{ block: this.block, elem: 'row', elemMods: { theme: 'grey', type: this.elem } }],
                label: [{ block: this.block, elem: 'label', elemMods: { type: this.elem } }],
                control: [{ block: this.block, elem: 'control', elemMods: { type: this.elem } }],
                info: [{ block: this.block, elem: 'info' }]
            },
            label: {
                block: this.block,
                elem: 'video-goals-label',
                cpmGroupType: group.cpmGroupType,
                isIndoorSegmentsEnabled: isIndoorSegmentsEnabled
            },
            control: {
                block: this.block,
                elem: 'video-goals-control',
                cpmGroupType: group.cpmGroupType,
                selected: group.video_goals || [],
                isIndoorSegmentsEnabled: isIndoorSegmentsEnabled
            }
        };
    })
);
