block('b-edit-group-2').elem('word-suggestions').def()(function() {
    var ctx = this.ctx;

    return {
        attrs: {
            row: { 'data-err-path': this.ctx.errPath }
        },
        mixes: {
            row: [
                {
                    block: 'b-edit-group-2',
                    elem: 'row',
                    elemMods: {
                        type: 'word-suggestions'
                    }
                },
                {
                    block: 'b-errors-presenter2',
                    elem: 'cleaner',
                    js: { block: 'b-group-add-phrases', event: 'suggestions-change' }
                },
                {
                    block: 'b-group-add-phrases',
                    modelParams: {
                        name: this.ctx.modelName || 'm-group',
                        id: this.group.modelId
                    },
                    mix: [{
                        block: 'b-group-add-phrases',
                        elem: 'new'
                    }],
                    banner: this.group,
                    mods: {
                        suggestions: this.ctx.showSuggestions ? 'on' : 'off'
                    },
                    js: {
                        id: 'new_phrases_' + this.group.modelId,
                        adgroupId: this.group.modelId,
                        modelParams: {
                            name: this.ctx.modelName || 'm-group',
                            id: this.group.modelId
                        }
                    }
                }
            ],
            label: [{
                block: 'b-edit-group-2',
                elem: 'label'
            }],
            info: [{
                block: 'b-edit-group-2',
                elem: 'info'
            }],
            control: [{
                block: 'b-edit-group-2',
                elem: 'control'
            }]
        },
        label: {
            block: 'b-group-add-phrases',
            elem: 'new-label',
            content: [
                iget2('b-edit-group-2', 'novye-klyuchevye-frazy', 'Новые ключевые фразы'),
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    stretched: true,
                    mix: [{
                        block: 'b-edit-group-2',
                        elem: 'help-icon'
                    }],
                    url: u.getHelpUrl(ctx.helpLinkId || 'add-keywords'),
                    title: iget2('b-edit-group-2', 'kak-pravilno-podbirat-klyuchevye', 'Как правильно подбирать ключевые фразы?')
                }
            ]
        },
        control: applyCtx([
            {
                block: 'b-error-pretty-message',
                js: true,
                mods: {
                    theme: 'classic',
                    toggleable: 'yes'
                },
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'pretty-errors-message'
                }
            },
            {
                block: 'button',
                mods: {
                    pseudo: 'yes'
                },
                mix: [{
                    block: 'b-group-add-phrases',
                    elem: 'suggestions-toggler'
                }],
                content: iget2('b-edit-group-2', 'pokazat-podskazki', 'Показать подсказки')
            },
            {
                block: 'b-outboard-controls',
                js: {
                    id: 'wordstat-control'
                },
                content: {
                    elem: 'switcher',
                    js: {
                        innerBlockParams: {
                            adgroupId: this.group.modelId,
                            modelName: this.ctx.modelName
                        }
                    },
                    switcher: {
                        block: 'button',
                        mods: {
                            theme: 'normal'
                        },
                        mix: [{
                            block: 'b-outboard-controls',
                            elem: 'switcher-button'
                        }],
                        content: iget2('b-edit-group-2', 'podobrat-slova', 'Подобрать слова')
                    }
                }
            },
            {
                block: 'b-group-add-phrases',
                elem: 'content-wrapper',
                elemMods: {
                    suggestions: this.ctx.showSuggestions ? 'on' : 'off'
                },
                modelParams: {
                    name: this.ctx.modelName || 'm-group',
                    id: this.group.modelId
                },
                group: this.ctx.group
            }
        ])
    };
});
