block('b-edit-group-2').mod('type', 'content-promotion')(

    def()(function() {
        if (!this.ctx.attrs) {
            this.ctx.attrs = {};
        }

        this.ctx.attrs['data-err-path'] = '[' + this.ctx.groupIndex.toString() + ']';
        this.ctx.mods['content-type'] = this.ctx.group.content_promotion_content_type || u['content-promotion'].getDefaultContentType();

        return applyNext();
    }),

    mode('setModel')(function() {
        var group = this.ctx.group;

        if (!group.group_name) group.group_name = iget2('b-edit-group-2', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

        this.groupModelName = 'dm-content-promotion-group';
        this.group = group;
        this.isSingleGroup = this.ctx.isSingleGroup;
        this.firstBanner = this.ctx.firstBanner;
        this.prevBanner = this.ctx.prevBanner;
        this.errors = group.errors || {};
        this.groupIndex = this.ctx.groupIndex;
        this.groupId = this.group.modelId;
        this.campaign = this.ctx.campaign;
    }),

    elem('group-data').content()(function() {
        var group = this.group;

        return {
            block: 'i-model-aggregator',
            content: [
                applyNext(),
                {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-adjustment-rates',
                        id: group.modelId,
                        data: group.hierarchicalMultipliers
                    }
                }
            ]
        };
    }),

    content()(function() {
        var data = this.data,
            campaign = this.campaign,
            group = this.group,
            availableCount = data.CONSTS.DEFAULT_CREATIVE_COUNT_LIMIT - 1 * group.banners_quantity,
            sortedPhrases = group.sorted.phrases,
            // блок с подсказками показываем только если мы на редактировании одной группы
            showSuggestions = this.data.campaign.groups.length == 1,
            hasPhrases = sortedPhrases &&
            (sortedPhrases.declined.length ||
                sortedPhrases.low_ctr.length ||
                sortedPhrases.context.length ||
                sortedPhrases.suspended.length ||
                sortedPhrases.active.length),
            groupContentBanners = [
                {
                    block: 'b-edit-group-2',
                    elem: 'rename-group',
                    elemMods: {
                        type: 'error2'
                    },
                    headerType: 'content_promotion',
                    helpText: iget2(
                        'b-edit-group-2',
                        'v-gruppe-vy-mozhete',
                        'В группе вы можете создать одно или несколько объявлений с общим набором ключевых фраз и едиными условиями показа.'
                    )
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'content-promotion-group-type-title',
                    isNewGroup: group.isNewGroup,
                    isCopyGroup: group.isCopyGroup,
                    selected: group.content_promotion_content_type,
                    campaignHasGroups: !!campaign.has_any_content_promotion_groups
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'banners-list',
                    attrs: { 'data-err-path': 'banners' },
                    content: group.banners.map(function(banner, index) {
                        banner.status_click_track = campaign.status_click_track;

                        return {
                            block: 'b-edit-banner2',
                            mods: {
                                type: 'content-promotion',
                                'content-type': group.content_promotion_content_type || u['content-promotion'].getDefaultContentType()
                            },
                            mix: [{
                                block: 'b-edit-group-2',
                                elem: 'banner-row',
                                elemMods: {
                                    'banner-id': banner.modelId
                                }
                            }],
                            banner: banner,
                            attrs: { 'data-err-path': index.toString() },
                            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
                            //если новый, не первый баннер в группе
                            canDelete: banner.bid == 0 && index > 0,
                            index: index,
                            campaign: data.campaign,
                            new_banner: data.new_banner,
                            hasHeaderActions: true,
                            group: group,
                            availableBannerCount: availableCount,
                            canEditDomain: this.ctx.canEditDomain,
                            isCopyGroup: group.isCopyGroup,
                            isNewOrCopyGroup: group.isNewGroup,
                            isSingleGroup: group.isSingleGroup,
                            errorPath: this.errorPath('banners[' + index + ']')
                        };
                    }, this)
                }
            ],
            groupContentBannerGroup = [
                {
                    control: {
                        block: 'b-edit-group-2',
                        attrs: {
                            id: 'Group-properties-' + this.group.modelId
                        },
                        elem: 'group-properties',
                        content: iget2('b-edit-group-2', 'nastroyki-na-vsyu-gruppu', 'Настройки на всю группу')
                    }
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'relevance-match',
                    strategy: data.campaign.strategy,
                    modelName: 'dm-content-promotion-group'
                },
                hasPhrases && {
                    block: 'b-edit-group-2',
                    elem: 'phrases',
                    errPath: 'keywords',
                    modelName: 'dm-content-promotion-group'
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'new-phrases',
                    errPath: 'new_keywords',
                    showSuggestions: showSuggestions,
                    modelName: 'dm-content-promotion-group',
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'word-suggestions',
                    errPath: 'keywords_suggestions',
                    group: group,
                    showSuggestions: showSuggestions,
                    modelName: 'dm-content-promotion-group',
                    helpLinkId: 'add-keywords-search'
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'minus-words',
                    errPath: 'minus_words',
                    modelName: 'dm-content-promotion-group'
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'regions',
                    errPath: 'geo',
                    parentModelName: 'dm-content-promotion-group'
                },
                group.has_general_limit_price && {
                    block: 'b-edit-group-2',
                    elem: 'limit-rate',
                    campDMParams: {
                        name: 'm-campaign'
                    },
                    modelParams: {
                        name: 'dm-content-promotion-group',
                        id: group.modelId
                    },
                    errPath: 'general_limit_price',
                    currency: data.campaign.currency,
                    helpLinkId: 'maximum-bid-search'
                },
                {
                    elem: 'adjustment-rates',
                    errPath: 'hierarchical_multipliers',
                    modelData: group.hierarchicalMultipliers,
                    tabsHash: u['b-adjustment-rates-popup'].getTabsHash({
                        hasRetargetingConditions: u.retargeting.hasRetargetingConditions(
                            this.data.all_retargeting_conditions,
                            'metrika_goals'
                        ),
                        mobile: true,
                        devices: hasEnabledFeatures('cpc_device_modifiers') || u.consts('isMobileOsBidModifierEnabled'),
                        demography: true,
                        retargeting: true,
                        performanceTGO: false
                    }),
                    helpLinkId: 'bids-adjustment-search'
                },
                this.data.tags_allowed == 'Yes' && {
                    block: 'b-edit-group-2',
                    elem: 'tags2',
                    tagsController: {
                        block: 'b-group-tags2-controller',
                        js: {
                            modelParams: {
                                group: {
                                    name: this.groupModelName,
                                    id: this.groupId
                                },
                                campaign: {
                                    name: 'm-campaign',
                                    id: this.data.campaign.cid
                                }
                            }
                        }
                    },
                    tags: u.groupTags2.makeTagsArray(data.campaign.tags || [], group.tags || {}),
                }
            ];

        return [
            applyNext(),
            apply('editLayout',{
                group: group,
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'banners-wrapper'
                },
                groupContent: groupContentBanners
            }),
            apply('editLayout', {
                group: group,
                groupContent: [{
                    block: 'b-edit-group-2',
                    elem: 'add-banner-button',
                    elemMods: {
                        type: 'new-error-display'
                    },
                    availableToCreateBannersCount: u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - group.banners_quantity,
                    mainTitle: iget2('b-edit-group-2', 'dobavit-obyavlenie', 'Добавить объявление'),
                    pluralTitles: [iget2('b-edit-group-2', 'obyavlenie', 'объявление'), iget2('b-edit-group-2', 'obyavleniya', 'объявления'), iget2('b-edit-group-2', 'obyavleniy', 'объявлений')],
                    errorPath: this.errorPath('banners')
                }]
            }),
            apply('editLayout', {
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'grey-wrapper'
                },
                group: group,
                groupContent: groupContentBannerGroup
            })
        ];
    })
);
