BEM.DOM.decl({ name: 'b-edit-group-2', modName: 'type', modVal: 'content-promotion' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._initGeneralLimitPrice(this.model);
        }
    },

    /**
     * @override {b-edit-group}
     */
    _additionalInit: function() {
        this.__base.apply(this, arguments);

        var tumbler = this.findBlockInside('relevance-match-tumbler', 'tumbler'),
            sbMan = this._getSubscriptionManager();

        if (tumbler) {
            sbMan.on(tumbler, 'change', function(e, data) {
                var isActive = data.value === 'true';

                this.model.set('has_relevance_match', isActive);
            }, this);
        }

        this._initContentPromotionGroupTypeSelector();
    },

    /**
     * @override {b-edit-group}
     */
    _getNewBannerModel: function(defaults) {
        var newBannerData = u._.extend({}, defaults);

        return this.model.addBanner(newBannerData);
    },

    /**
     * @override {b-edit-group}
     */
    _onBeforeBannerAdd: function(bannerModel) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') + 1);
    },

    /**
     * @override {b-edit-group}
     */
    _onBeforeBannerRemove: function(bannerId) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') - 1);
    },

    /**
     * @override {b-edit-group}
     */
    _getAvailableToCreateBannersCount: function() {
        return u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - this.model.get('banners_quantity');
    },

    /**
     * @override {b-edit-group}
     */
    _updateCountInBlocks: function(available) {
        this._banners
            .forEach(function(banner) {
                banner.updateAvailableBannerCount(available);
            });
    },

    /**
     * Возвращает контейнер списка баннеров
     * @returns {$}
     */
    _getBannersListContainer: function() {
        return this.elem('banners-list');
    },

    /**
     * @override {b-edit-group}
     */
    _getEditBlockBemjson: function(bannerModel) {
        var bannerData = bannerModel.provideData();

        return u._.extend({}, this.params.newBannerData, {
            block: 'b-edit-banner2',
            mods: {
                type: 'content-promotion',
                'content-type': bannerModel.get('content_promotion_content_type')
            },
            canDelete: true,
            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
            banner: bannerData,
            group: u._.extend(this.model.provideData(), { modelId: this.model.id }),
            campaign: this.model.getCampaignModel().toJSON(),
            noModelData: true,
            modelParams: {
                name: bannerModel.name,
                id: bannerModel.id,
                parentModel: this.model
            },
            hasHeaderActions: true,
            attrs: { 'data-err-path': this.model.get('banners_quantity') - 1 },
            availableBannerCount: this._getAvailableToCreateBannersCount(),
            errorPath: this._errorPathBuilder(this.model.get('banners_quantity') - 1) // визуальные индексы на 1 больше индексов для ошибок
        });
    },

    /**
     * Возвращает инстанс селекта «Площадка размещения контента»
     * @returns {BEM}
     * @private
     */
    _getContentPromotionGroupTypeSelector: function() {
        return this._groupTypeSelector ||
            (this._groupTypeSelector = this.findBlockOn('content-promotion-group-type-selector', 'select2'));
    },

    /**
     * Инициализация селекта типа партнерского контента (тип группы)
     * @private
     */
    _initContentPromotionGroupTypeSelector: function() {
        if (!this._getContentPromotionGroupTypeSelector()) {
            return;
        }

        this._getSubscriptionManager()
            .on(this._getContentPromotionGroupTypeSelector(), 'change', this._onContentPromotionGroupTypeSelectorChange, this)
            .on(this.model, 'content_promotion_content_type', 'change', this._onAdGroupTypeChange, this);
    },

    /**
     * колбек на событие изменения типа партнерского контента в селекторе
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onContentPromotionGroupTypeSelectorChange: function(e, data) {
        var contentType = data.currVal;

        this.model.set('content_promotion_content_type', contentType);
    },

    /**
     * колбек на изменения типа группы в data-модели группы
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onAdGroupTypeChange: function(e, data) {
        var modType = u.beminize(data.value);

        this.setMod('content-type', modType)
            .findBlocksInside('b-edit-banner2')
            .forEach(function(banner) {
                banner.model.set('content_promotion_content_type', data.value);
            });
    }
});
