block('b-edit-group-2').mod('type', 'cpm-deals')(

    def()(function() {
        if (!this.ctx.attrs) {
            this.ctx.attrs = {};
        }

        this.ctx.attrs['data-err-path'] = '[' + this.ctx.groupIndex.toString() + ']';
        this.ctx.mods['display-conditions'] = this.ctx.group.displayConditions;
        this.ctx.mods['cpm-group-type'] = u.beminize(this.ctx.group.cpmGroupType);

        var keywordsAdjustmentTabs = u['b-adjustment-rates-popup'].getTabsHash({
            hasRetargetingConditions: !u._.isEmpty(this.data.all_retargeting_conditions),
            demography: true,
            devices: true,
            video: false,
            retargeting: true,
            performanceTGO: false,
            weather: true
        });

        this.adjustmentRatesTabs = {
            cpm_banner: {
                keywords: keywordsAdjustmentTabs,
                crypta: u['b-adjustment-rates-popup'].getTabsHash({
                    devices: true,
                    weather: true
                })
            },
            cpm_video: {
                keywords: keywordsAdjustmentTabs,
                crypta: u['b-adjustment-rates-popup'].getTabsHash({
                    devices: hasEnabledFeatures('cpm_video_device_modifiers'),
                    weather: true
                })
            }
        };

        return applyNext();
    }),

    addJs()(function() {
        return {
            adjustmentRatesTabs: this.adjustmentRatesTabs
        };
    }),

    mode('setModel')(function() {
        var group = this.ctx.group;

        if (!group.group_name) group.group_name = iget2('b-edit-group-2', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

        this.groupModelName = 'dm-cpm-deals-group';
        this.group = group;
        this.isSingleGroup = this.ctx.isSingleGroup;
        this.firstBanner = this.ctx.firstBanner;
        this.prevBanner = this.ctx.prevBanner;
        this.errors = group.errors || {};
        this.groupIndex = this.ctx.groupIndex;
        this.groupId = this.group.modelId;
        this.campaign = this.ctx.campaign;
    }),

    elem('group-data').content()(function() {
        var group = this.group;

        return {
            block: 'i-model-aggregator',
            content: [
                applyNext(),
                {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-adjustment-rates',
                        id: group.modelId,
                        data: group.hierarchicalMultipliers
                    }
                }
            ]
        };
    }),

    content()(function() {
        var data = this.data,
            campaign = this.campaign,
            group = this.group,
            availableCount = data.CONSTS.DEFAULT_CREATIVE_COUNT_LIMIT - 1 * group.banners_quantity,
            sortedPhrases = group.sorted.phrases,
            //блок с подсказками показываем только если мы на редактировании одной группы
            showSuggestions = data.campaign.groups.length == 1,
            retargetingInterests = (group.retargetings || []).slice(0).reduce(function(result, groupRet) {
                var retargeting = data.all_retargeting_conditions[groupRet.ret_cond_id];

                if (retargeting.retargeting_conditions_type === 'interests') {
                    result.push(u._.extend({}, retargeting, {
                        // докидываем нужные поля
                        ret_id: groupRet.ret_id
                    }));
                }

                return result;
            }, []),
            hasPhrases = sortedPhrases &&
            (sortedPhrases.declined.length ||
                sortedPhrases.low_ctr.length ||
                sortedPhrases.context.length ||
                sortedPhrases.suspended.length ||
                sortedPhrases.active.length),
            groupContentBanners = [
                {
                    block: 'b-edit-group-2',
                    elem: 'rename-group',
                    errPath: 'group_name'
                },
                // TODO https://st.yandex-team.ru/DIRECT-80774#1531393396000
                // TODO ждем видео для сделок
                // u.consts('rights').allowedCpmVideoBanners && {
                //     block: 'b-edit-group-2',
                //     elem: 'cpm-group-type-title',
                //     isNewGroup: group.isNewGroup,
                //     isCopyGroup: group.isCopyGroup,
                //     selected: group.cpmGroupType
                // },
                {
                    block: 'b-edit-group-2',
                    elem: 'banners-list',
                    attrs: { 'data-err-path': 'banners' },
                    content: group.banners.map(function(banner, index) {
                        banner.status_click_track = campaign.status_click_track;

                        return {
                            block: 'b-edit-banner2',
                            mix: [{
                                block: 'b-edit-group-2',
                                elem: 'banner-row',
                                elemMods: {
                                    'banner-id': banner.modelId
                                }
                            }],
                            mods: {
                                type: 'cpm-deals', // cyn@TOOD: deals
                                'cpm-group-type': u.beminize(group.cpmGroupType)
                            },
                            attrs: { 'data-err-path': index.toString() },
                            banner: banner,
                            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
                            //если новый, не первый баннер в группе
                            canDelete: banner.bid == 0 && index > 0,
                            //common: data.common,
                            index: index,
                            campaign: data.campaign,
                            new_banner: data.new_banner,
                            hasHeaderActions: true,
                            group: group,
                            withVCard: true,
                            availableBannerCount: availableCount,
                            canEditDomain: this.ctx.canEditDomain,
                            isCopyGroup: group.isCopyGroup,
                            isSingleGroup: group.isSingleGroup,
                            errorPath: this.errorPath('banners[' + index + ']'),
                            promoCodeDomains: data.promocode_domains
                        };
                    }, this)
                }
            ],
            groupContentBannerGroup = [
                {
                    mixes: {
                        row: [
                            {
                                block: 'b-edit-group-2',
                                elem: 'group-properties-row'
                            }
                        ]
                    },
                    control: {
                        block: 'b-edit-group-2',
                        attrs: {
                            id: 'Group-properties-' + this.group.modelId
                        },
                        elem: 'group-properties',
                        content: iget2('b-edit-group-2', 'nastroyki-na-vsyu-gruppu', 'Настройки на всю группу')
                    }
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'regions',
                    parentModelName: 'dm-cpm-deals-group',
                    errPath: 'geo'
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'display-conditions',
                    isNewGroup: this.isNewGroup,
                    isCopyGroup: this.isCopyGroup,
                    cpmGroupType: group.cpmGroupType,
                    selected: group.displayConditions
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'crypta',
                    pid: group.pid,
                    retargeting: retargetingInterests[0],
                    errPath: 'targetInterests'
                },
                hasPhrases && {
                    block: 'b-edit-group-2',
                    elem: 'phrases',
                    modelName: 'dm-cpm-deals-group',
                    campaignModelName: 'dm-cpm-deals-campaign',
                    errPath: 'keywords'
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'new-phrases',
                    showSuggestions: showSuggestions,
                    modelName: 'dm-cpm-deals-group',
                    campaignModelName: 'dm-cpm-deals-campaign',
                    errPath: 'new_keywords'
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'word-suggestions',
                    group: group,
                    errorPath: this.errorPath('keywords'),
                    showSuggestions: showSuggestions,
                    modelName: 'dm-cpm-deals-group',
                    errPath: 'keywords_suggestions'
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'minus-words',
                    modelName: 'dm-cpm-deals-group',
                    minusWordsMods: { type: 'cpm' },
                    errPath: 'minus_words'
                },
                {
                    elem: 'adjustment-rates',
                    modelData: group.hierarchicalMultipliers,
                    tabsHash: u._.get(this.adjustmentRatesTabs, [group.cpmGroupType, group.displayConditions]),
                    errPath: 'hierarchical_multipliers'
                },
                group.has_general_limit_price && {
                    block: 'b-edit-group-2',
                    elem: 'limit-rate',
                    labelContent: [
                        {
                            block: 'b-edit-group-2',
                            elem: 'limit-rate-label-keywords',
                            content: [
                                iget2('b-edit-group-2', 'maksimalnaya-stavka-za-tys', 'Максимальная ставка за тыс. показов для новых и измененных условий показа'),
                                {
                                    block: 'b-help-link',
                                    mods: {
                                        type: 'modal'
                                    },
                                    stretched: true,
                                    mix: [{
                                        block: 'b-edit-group-2',
                                        elem: 'help-icon'
                                    }],
                                    url: u.getHelpUrl('maximum-bid-cpm-campaign')
                                }
                            ]
                        },
                        {
                            block: 'b-edit-group-2',
                            elem: 'limit-rate-label-crypta',
                            content: [
                                iget2('b-edit-group-2', 'maksimalnaya-stavka', 'Максимальная ставка'),
                                {
                                    block: 'b-help-link',
                                    mods: {
                                        type: 'modal'
                                    },
                                    stretched: true,
                                    mix: [{
                                        block: 'b-edit-group-2',
                                        elem: 'help-icon'
                                    }],
                                    url: u.getHelpUrl('maximum-bid-cpm-campaign')
                                }
                            ]
                        }
                    ],
                    price: group.general_limit_price || undefined,
                    targetText: iget2('b-edit-group-2', 'tys-pokazov-2', 'тысячу показов'),
                    campDMParams: {
                        name: 'dm-cpm-deals-campaign'
                    },
                    modelParams: {
                        name: 'dm-cpm-deals-group',
                        id: group.modelId
                    },
                    currency: data.campaign.currency,
                    errPath: 'auto_price'
                },
                this.data.tags_allowed == 'Yes' && {
                    block: 'b-edit-group-2',
                    elem: 'tags',
                    tagsList: u.groupTags2.makeTagsArray(data.campaign.tags || [], group.tags || {}),
                    modelName: 'dm-cpm-deals-group',
                    campaignModelName: 'dm-cpm-deals-campaign'
                }
            ];

        return [
            applyNext(),
            apply('editLayout',{
                group: group,
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'banners-wrapper'
                },
                groupContent: groupContentBanners
            }),
            apply('editLayout', {
                group: group,
                groupContent: [{
                    block: 'b-edit-group-2',
                    elem: 'add-banner-button',
                    elemMods: {
                        type: 'new-error-display'
                    },
                    availableToCreateBannersCount: u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - group.banners_quantity,
                    mainTitle: iget2('b-edit-group-2', 'dobavit-banner', 'Добавить баннер'),
                    pluralTitles: [iget2('b-edit-group-2', 'obyavlenie', 'объявление'), iget2('b-edit-group-2', 'obyavleniya', 'объявления'), iget2('b-edit-group-2', 'obyavleniy', 'объявлений')],
                    errorPath: this.errorPath('banners')
                }]
            }),
            apply('editLayout', {
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'grey-wrapper'
                },
                group: group,
                groupContent: groupContentBannerGroup
            })
        ];
    })

);
