BEM.DOM.decl({ name: 'b-edit-group-2', modName: 'type', modVal: 'cpm-deals' }, {

    _isReady: null,

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._initGeneralLimitPrice(this.model)
                ._initDisplayConditionsSelector()
                ._initCpmGroupTypeSelector();
        }
    },

    /**
     * Возвращает значение флага
     * @returns {boolean}
     */
    isReady: function() {
        return !!this._isReady;
    },

    _initDisplayConditionsSelector: function() {
        if (this._getDisplaySelector()) {
            this._getSubscriptionManager().on(this._getDisplaySelector(), 'change', function(e, data) {
                this.model.set('displayConditions', data.currVal);
            }, this);

            this._getSubscriptionManager().on(this.model, 'displayConditions', 'change', function(e, data) {
                this.setMod('display-conditions', data.value);

                this._updateAdjustmentRates();

                if (this._getDisplaySelector()) {
                    this._getDisplaySelector().setVal(data.value);
                }
            }, this);
        }

        return this;
    },

    _onCpmGroupTypeChange: function() {
        this.__base.apply(this, arguments);

        this._updateAdjustmentRates();
    },

    _getDisplaySelector: function() {
        return this._displaySelector ||
            (this._displaySelector = this.findBlockOn('display-conditions-selector', 'select2'));
    },

    /**
     * Инициализирует связи блока 'Условия подбора аудиторий' с моделью группы
     * @private
     */
    _initRetargeting: function() {
        // не у всех типов кампаний есть 'Условия подбора аудиторий'
        if (!this._getCryptaSettingsBlock()) {
            return;
        }

        this._getSubscriptionManager().wrap(this._getCryptaSettingsBlock())
            .on('conditions:add', function(event, data) {
                this.model.get('retargetingsInterests').add(data.model);
            }, this)
            .on('ready', function() {
                this._isReady = true;
                this.trigger('ready');
            }, this);

        this._getSubscriptionManager().wrap(this.model)
            .on('retargetingsInterests banners','change', this._updateInventory, this);

        this._getSubscriptionManager().wrap(this.model.getGeoModel())
            .on('geoText','change', this._updateInventory, this);
    },

    /**
     * @override {b-edit-group-2}
     */
    _getNewBannerModel: function(defaults) {
        var newBannerData = u._.extend({}, defaults);

        return this.model.addBanner(newBannerData);
    },

    /**
     * @override {b-edit-group-2}
     */
    _onBeforeBannerAdd: function(bannerModel) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') + 1);
    },

    /**
     * @override {b-edit-group-2}
     */
    _onBeforeBannerRemove: function(bannerId) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') - 1);
    },

    /**
     * @override {b-edit-group-2}
     */
    _getAvailableToCreateBannersCount: function() {
        return u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - this.model.get('banners_quantity');
    },

    /**
     * @override {b-edit-group-2}
     */
    _updateCountInBlocks: function(available) {
        this._banners
            .forEach(function(banner) {
                banner.updateAvailableBannerCount(available);
            });
    },

    _removeBanner: function() {
        this.__base.apply(this, arguments);

        this.findBlocksInside('b-edit-banner2').forEach(function(block, index) {
            block.domElem.attr('data-err-path', index.toString());
        });
    },

    /**
     * @override {b-edit-group-2}
     */
    _getEditBlockBemjson: function(bannerModel) {
        var bannerData = bannerModel.provideData(),
            bannerIndex = this.model.get('banners').length() - 1;

        return u._.extend({}, this.params.newBannerData, {
            block: 'b-edit-banner2',
            mods: {
                type: 'cpm-deals',
                'cpm-group-type': this.getMod('cpm-group-type')
            },
            attrs: { 'data-err-path': '' + bannerIndex },
            canDelete: true,
            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
            banner: bannerData,
            group: u._.extend(
                this.model.provideData(),
                {
                    modelId: this.model.id,
                    cpmGroupType: this.model.get('cpmGroupType')
                }
            ),
            campaign: this.model.getCampaignModel().toJSON(),
            noModelData: true,
            modelParams: {
                name: bannerModel.name,
                id: bannerModel.id,
                parentModel: this.model
            },
            availableBannerCount: this._getAvailableToCreateBannersCount(),
            errorPath: this._errorPathBuilder(this.model.get('banners_quantity') - 1) // визуальные индексы на 1 больше индексов для ошибок
        });
    },

    _updateAdjustmentRates: function() {
        var currentDisplayConditions = this.getMod('display-conditions'),
            currentCpmGroupType = this.model.get('cpmGroupType'),
            adjRatesTabs = u._.get(
                this.params,
                ['adjustmentRatesTabs', currentCpmGroupType, currentDisplayConditions]
            ),
            groupId = this.model.id,
            adjRatesModel = BEM.MODEL.getOrCreate({ name: 'm-adjustment-rates', id: groupId }),
            tabsList = Object.keys(adjRatesTabs.tabs),
            adjRatesControl = this.findElem('adjustment-rates-control');

        // Корректировки влияют на прогноз
        this._updateInventory();

        this.setMod(this.elem('row', 'type', 'adjustment-rates'), 'empty', tabsList.length ? '' : 'yes');

        // Удаление блока может повлиять на модель, поэтому сначала удаляем блок, а потом черпаем сведения из модели
        BEM.DOM.destruct(true, adjRatesControl);
        BEM.DOM.init(
            $(BEMHTML.apply({
                block: 'b-adjustment-rates-popup',
                mix: [
                    {
                        block: 'b-errors-presenter2',
                        elem: 'cleaner',
                        js: { block: 'b-adjustment-rates-popup', event: 'save' }
                    },
                    { block: 'b-edit-group-2', elem: 'adjustment-rates-control' }
                ],
                modelId: groupId,
                tabsHash: adjRatesTabs,
                content: [
                    { elem: 'switcher' },
                    { elem: 'rates', modelData: u._.pick(adjRatesModel.toJSON(), tabsList) }
                ],
                modal: true
            })).replaceAll(adjRatesControl)
        );
    },

    _onAdjustmentRatesChange: function() {
        // обновляем корректировки целиком, потому что некоторые табы в новом типе могут быть не доступны
        // (не смотря на то что в модели они заданы)
        this._updateAdjustmentRates();
    }
});
