BEM.DOM.decl({ name: 'b-edit-group-2', modName: 'type', modVal: 'cpm-full' }, {

    _isReady: null,

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);
            this.selector = this.findBlockInside('cpm-group-type-selector', 'button2');

            this._initGeneralLimitPrice(this.model)
                ._initDisplayConditionsSelector()
                ._initCpmGroupTypeSelector()
                ._initVideoGoals()
                ._initOutdoor()
                ._initIndoor();

            // открытие селектора должно исчезнуть в DIRECT-104413
            this.model.get('isNewGroup') && this._openSelector()
        }
    },

    _openSelector: function() {
        if (!this.selector) {
            throw new Error('selector is not found')
        }

        // Блок "selector2" не предоставляет возможность отрисовать компонент с изначальным открытым попапом.
        // Решил пока сделать так, т.к. это место должно переделываться в DIRECT-104413
        this.selector.domElem.click();
    },

    _initVideoGoals: function() {
        this._getSubscriptionManager()
            .on(BEM.blocks['checkbox'], this.findElem('video-goal-checkbox'), 'change', function(e, data) {
                this._onVideoGoalChange(e.block.val(), data.checked);
            }, this);

        return this;
    },

    _onVideoGoalChange: function(value, isChecked) {
        isChecked ?
            this.model.get('video_goals').push({ type: value }) :
            this.model.set(
                'video_goals',
                this.model.get('video_goals').filter(function(goal) { return goal.type !== value; })
            );
    },

    /**
     * Возвращает значение флага
     * @returns {boolean}
     */
    isReady: function() {
        return !!this._isReady;
    },

    _initOutdoor: function() {
        if (this._getOutdoorControl()) {
            this._getSubscriptionManager().wrap(this._getOutdoorControl())
                .on('save', function(e, data) {
                    this.model.set('outdoorPoints', data.selected || []);
                    this.model.set('outdoorFormats', data.formats || []);
                }, this)
                .on('initFormats', function(e, data) {
                    this.model.set('outdoorFormats', data.formats || []);
                }, this);

            this._getSubscriptionManager().wrap(this.model)
                .on('outdoorFormats', 'change', function() {
                    this._checkOutdoorWarnings();
                }, this)
                .on('banners', 'change', function(e, data) {
                    if (this.model.get('cpmGroupType') === 'cpm_outdoor' && data.innerField === 'creative') {
                        this._checkOutdoorWarnings();
                    }
                }, this)
                .on('cpmGroupType', 'change', function() {
                    this._updateOutdoorWarnings([], 0);
                }, this);
        }

        return this;
    },

    /**
     * Возвращает максимальное разрешения для щита по его соотношению сторон
     * @param {String} data 720×360
     * @returns {String}
     * @private
     */
    _getMaxResolution: function(data) {
        var nod = function(x, y) {
                if (y > x) return nod(y, x);
                if (!y) return x;

                return nod(y, x % y);
            },
            size = data.split('×'),
            aspectRatio = size.map(function(item) {
                return item / nod(size[0], size[1]);
            }).join('/'),
            maxResolution = {
                '2/1': '1440×720'
            };

        return maxResolution[aspectRatio] || data;
    },

    _checkOutdoorWarnings: function() {
        var formats,
            creativeResolutions = [],
            creativeResolutionsWithDuration = [],
            suitablePage = 0;

        if (this.model.get('outdoorFormats').length) {
            this.model.getBanners().forEach(function(model) {
                var creative = model.get('creative'),
                    resolutions = creative.get('outdoorResolutions');

                if (resolutions.length) {

                    resolutions.forEach(function(resolution) {
                        creativeResolutionsWithDuration.push([resolution, creative.get('duration')].join('-'));
                    });

                    creativeResolutions = creativeResolutions.concat(resolutions);
                }
            }, this);

            if (creativeResolutions.length) {
                formats = this.model.get('outdoorFormats').reduce(function(res, item) {
                    var resolutionPage = item.duration ? [item.resolution, item.duration].join('-') : item.resolution,
                        needFormat = item.duration ?
                            creativeResolutionsWithDuration.indexOf(resolutionPage) === -1 :
                            creativeResolutions.indexOf(item.resolution) === -1;

                    if (needFormat) {
                        res.push(resolutionPage);
                    } else {
                        ++suitablePage;
                    }

                    return res;
                }, []);
            }

            this._updateOutdoorWarnings(u._.uniq(formats), suitablePage);
        }

    },

    _updateOutdoorWarnings: function(data, suitablePage) {
        var _this = this,
            formats = data.reduce(function(res, item) {
                var part = item.split('-'),
                    duration = part[1] ?
                        (', ' + iget2('b-edit-group-2', 'duration', '{duration} сек', { duration: part[1] })) :
                        '';

                res.push(_this._getMaxResolution(part[0]) + 'px' + duration);

                return res;
            }, []),
            totalPage = this.model.get('outdoorFormats').length,
            percent = u.numberFormatter.format(suitablePage * 100 / totalPage, { precision: 0 }),
            text = suitablePage === 0 ?
                iget2('b-edit-banner2', 'warning-for-outdoor-group-without-page', 'У Ваших объявлений нет показов. Добавьте креативы подходящих форматов:') :
                iget2('b-edit-banner2', 'warning-for-outdoor-group-with-page', 'Ваши объявления показываются на {percent}% щитов ({suitablePage} из {totalPage}). Добавьте креативы подходящих форматов:',
                    {
                        percent: percent,
                        suitablePage: suitablePage,
                        totalPage: totalPage
                    }
                );

        BEM.DOM.update(this.elem('warning-outdoor-group'), BEMHTML.apply({
            block: 'warning-message',
            mix: {
                block: 'b-edit-banner2',
                elem: 'warning-message-outdoor-group'
            },
            text: formats.length && suitablePage !== totalPage ? text : '',
            list: formats
        }));
    },

    _getOutdoorControl: function() {
        return this._outdoorControl ||
            (this._outdoorControl = this.findBlockOn('outdoor-map', 'b-outdoor-map'));
    },

    _initIndoor: function() {
        if (this._getIndoorControl()) {
            this._getSubscriptionManager().on(this._getIndoorControl(), 'save', function(e, data) {
                this.model.set('indoorPoints', data.selected || []);
            }, this);
        }
    },

    _getIndoorControl: function() {
        return this._indoorControl ||
            (this._indoorControl = this.findBlockOn('indoor-map', 'b-display-map-chooser'));
    },

    _initDisplayConditionsSelector: function() {
        if (this._getDisplaySelector()) {
            this._getSubscriptionManager().on(this._getDisplaySelector(), 'change', function(e, data) {
                this.model.set('displayConditions', data.currVal);
            }, this);

            this._getSubscriptionManager().on(this.model, 'displayConditions', 'change', function(e, data) {
                this.setMod('display-conditions', data.value);

                if (this.model.get('cpmGroupType') !== 'cpm_outdoor' && this.model.get('cpmGroupType') !== 'cpm_indoor') {
                    this._updateAdjustmentRates();
                }

                if (this._getDisplaySelector()) {
                    this._getDisplaySelector().setVal(data.value);
                }
            }, this);
        }

        return this;
    },

    _onCpmGroupTypeChange: function() {
        this.__base.apply(this, arguments);

        this._updateAdjustmentRates();

        this
            ._updateVideoGoals()
            ._initVideoGoals();
    },

    _getDisplaySelector: function() {
        return this._displaySelector ||
            (this._displaySelector = this.findBlockOn('display-conditions-selector', 'select2'));
    },

    /**
     * Инициализирует связи блока 'Условия подбора аудиторий' с моделью группы
     * @private
     */
    _initRetargeting: function() {
        // не у всех типов кампаний есть 'Условия подбора аудиторий'
        if (!this._getCryptaSettingsBlock()) {
            this._isReady = true;
            this.trigger('ready');

            return;
        }

        this._getSubscriptionManager().wrap(this._getCryptaSettingsBlock())
            .on('conditions:add', function(event, data) {
                this.model.get('retargetingsInterests').add(data.model);
            }, this)
            .on('ready', function() {
                this._isReady = true;
                this.trigger('ready');
            }, this);

        this._getSubscriptionManager().wrap(this.model)
            .on('retargetingsInterests banners','change', this._updateInventory, this);

        this._getSubscriptionManager().wrap(this.model.getGeoModel())
            .on('geoText','change', this._updateInventory, this);
    },

    /**
     * @override {b-edit-group-2}
     */
    _getNewBannerModel: function(defaults) {
        var newBannerData = u._.extend({}, defaults);

        return this.model.addBanner(newBannerData);
    },

    /**
     * @override {b-edit-group-2}
     */
    _onBeforeBannerAdd: function(bannerModel) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') + 1);
    },

    /**
     * @override {b-edit-group-2}
     */
    _onBeforeBannerRemove: function(bannerId) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') - 1);
    },

    /**
     * @override {b-edit-group-2}
     */
    _getAvailableToCreateBannersCount: function() {
        return u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - this.model.get('banners_quantity');
    },

    /**
     * @override {b-edit-group-2}
     */
    _updateCountInBlocks: function(available) {
        this._banners
            .forEach(function(banner) {
                banner.updateAvailableBannerCount(available);
            });
    },

    _removeBanner: function() {
        this.__base.apply(this, arguments);

        this.findBlocksInside('b-edit-banner2').forEach(function(block, index) {
            block.domElem.attr('data-err-path', index.toString());
        });
    },

    /**
     * @override {b-edit-group-2}
     */
    _getEditBlockBemjson: function(bannerModel) {
        var bannerData = bannerModel.provideData(),
            bannerIndex = this.model.get('banners').length() - 1;

        return u._.extend({}, this.params.newBannerData, {
            block: 'b-edit-banner2',
            mods: {
                type: 'cpm',
                'cpm-group-type': this.getMod('cpm-group-type')
            },
            attrs: { 'data-err-path': '' + bannerIndex },
            canDelete: true,
            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
            banner: bannerData,
            group: u._.extend(
                this.model.provideData(),
                {
                    modelId: this.model.id,
                    cpmGroupType: this.model.get('cpmGroupType')
                }
            ),
            campaign: this.model.getCampaignModel().toJSON(),
            noModelData: true,
            modelParams: {
                name: bannerModel.name,
                id: bannerModel.id,
                parentModel: this.model
            },
            availableBannerCount: this._getAvailableToCreateBannersCount(),
            errorPath: this._errorPathBuilder(this.model.get('banners_quantity') - 1) // визуальные индексы на 1 больше индексов для ошибок
        });
    },

    _updateAdjustmentRates: function() {
        var currentDisplayConditions = this.getMod('display-conditions'),
            currentCpmGroupType = this.model.get('cpmGroupType'),
            adjRatesTabs = u._.get(
                this.params,
                ['adjustmentRatesTabs', currentCpmGroupType, currentDisplayConditions]
            ),
            groupId = this.model.id,
            adjRatesModel = BEM.MODEL.getOrCreate({ name: 'm-adjustment-rates', id: groupId }),
            tabsList = Object.keys(adjRatesTabs.tabs),
            adjRatesControl = this.findElem('adjustment-rates-control');

        // Корректировки влияют на прогноз
        this._updateInventory();

        this.setMod(this.elem('row', 'type', 'adjustment-rates'), 'empty', tabsList.length ? '' : 'yes');

        // Не BEM.DOM.replace, потому что удаление блока может повлиять на модель,
        // поэтому сначала удаляем блок, а потом черпаем сведения из модели
        BEM.DOM.destruct(true, adjRatesControl);
        BEM.DOM.init(
            $(BEMHTML.apply({
                block: 'b-adjustment-rates-popup',
                mix: [
                    {
                        block: 'b-errors-presenter2',
                        elem: 'cleaner',
                        js: { block: 'b-adjustment-rates-popup', event: 'save' }
                    },
                    { block: 'b-edit-group-2', elem: 'adjustment-rates-control' }
                ],
                modelId: groupId,
                tabsHash: adjRatesTabs,
                content: [
                    { elem: 'switcher' },
                    { elem: 'rates', modelData: u._.pick(adjRatesModel.toJSON(), tabsList) }
                ],
                modal: true
            })).replaceAll(adjRatesControl)
        );
    },

    _updateVideoGoals: function() {
        var groupType = this.model.get('cpmGroupType'),
            isIndoorSegmentsEnabled = this.params.isIndoorSegmentsEnabled,
            isVideoGoalsHidden = (groupType === 'cpm_indoor') && !isIndoorSegmentsEnabled;

        this.setMod(this.elem('row', 'type', 'video-goals'), 'hidden', isVideoGoalsHidden ? 'yes' : '');

        BEM.DOM.update(this.elem('label', 'type', 'video-goals'), BEMHTML.apply({
            block: this.__self.getName(),
            elem: 'video-goals-label',
            cpmGroupType: groupType,
            isIndoorSegmentsEnabled: isIndoorSegmentsEnabled
        }));

        BEM.DOM.update(this.elem('control', 'type', 'video-goals'), BEMHTML.apply({
            block: this.__self.getName(),
            elem: 'video-goals-control',
            cpmGroupType: groupType,
            isIndoorSegmentsEnabled: isIndoorSegmentsEnabled,
            selected: this.model.get('video_goals')
        }));

        return this;
    },

    _onAdjustmentRatesChange: function() {
        // обновляем корректировки целиком, потому что некоторые табы в новом типе могут быть не доступны
        // (не смотря на то что в модели они заданы)
        this._updateAdjustmentRates();
    },

    /**
     * Реакция на нажатие кнопки удаления баннера
     * @param {String} bannerId
     */
    _onBannerRemoveRequest: function(bannerId) {
        this.__base.apply(this, arguments);

        this.model.get('cpmGroupType') === 'cpm_outdoor' && this._checkOutdoorWarnings();
    },
});
