block('b-edit-group-2').mod('type', 'cpm-yndx-frontpage-full')(

    def()(function() {
        if (!this.ctx.attrs) {
            this.ctx.attrs = {};
        }

        this.ctx.attrs['data-err-path'] = '[' + this.ctx.groupIndex.toString() + ']';
        this.ctx.mods['display-conditions'] = this.ctx.group.displayConditions;
        this.ctx.mods['cpm-yndx-frontpage-group-type'] = u.beminize(this.ctx.group.cpmGroupType);

        return applyNext();
    }),

    mode('setModel')(function() {
        var group = this.ctx.group;

        if (!group.group_name) group.group_name = iget2('b-edit-group-2', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

        this.groupModelName = 'dm-cpm-yndx-frontpage-banner-group';
        this.group = group;
        this.isSingleGroup = this.ctx.isSingleGroup;
        this.firstBanner = this.ctx.firstBanner;
        this.prevBanner = this.ctx.prevBanner;
        this.errors = group.errors || {};
        this.groupIndex = this.ctx.groupIndex;
        this.groupId = this.group.modelId;
        this.campaign = this.ctx.campaign;
    }),

    elem('group-data').content()(function() {
        return {
            block: 'i-model-aggregator',
            content: [
                applyNext()
            ]
        };
    }),

    content()(function() {
        var data = this.data,
            campaign = this.campaign,
            group = this.group,
            availableCount = data.CONSTS.DEFAULT_CREATIVE_COUNT_LIMIT - 1 * group.banners_quantity,
            retargetingInterests = (group.retargetings || []).slice(0).reduce(function(result, groupRet) {
                var retargeting = data.all_retargeting_conditions[groupRet.ret_cond_id];

                if (retargeting.retargeting_conditions_type === 'interests') {
                    result.push(u._.extend({}, retargeting, {
                        // докидываем нужные поля
                        ret_id: groupRet.ret_id
                    }));
                }

                return result;
            }, []),
            groupContentBanners = [
                {
                    block: 'b-edit-group-2',
                    elem: 'rename-group',
                    errPath: 'group_name'
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'banners-list',
                    attrs: { 'data-err-path': 'banners' },
                    content: group.banners.map(function(banner, index) {
                        banner.status_click_track = campaign.status_click_track;

                        return {
                            block: 'b-edit-banner2',
                            mix: [{
                                block: 'b-edit-group-2',
                                elem: 'banner-row',
                                elemMods: {
                                    'banner-id': banner.modelId
                                }
                            }],
                            mods: {
                                type: 'cpm-yndx-frontpage',
                                'cpm-yndx-frontpage-group-type': u.beminize(group.cpmGroupType)
                            },
                            attrs: { 'data-err-path': index.toString() },
                            banner: banner,
                            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
                            //если новый, не первый баннер в группе
                            canDelete: banner.bid == 0 && index > 0,
                            //common: data.common,
                            index: index,
                            campaign: data.campaign,
                            new_banner: data.new_banner,
                            hasHeaderActions: true,
                            group: group,
                            withVCard: true,
                            availableBannerCount: availableCount,
                            canEditDomain: this.ctx.canEditDomain,
                            isCopyGroup: group.isCopyGroup,
                            isSingleGroup: group.isSingleGroup,
                            promoCodeDomains: data.promocode_domains,
                            isNewGroup: !!data.new_group
                        };
                    }, this)
                },
            ];

        var regions = {
            block: 'b-edit-group-2',
            elem: 'regions',
            parentModelName: 'dm-cpm-yndx-frontpage-banner-group',
            errPath: 'geo'
        };
        var limitRate = {
            block: 'b-edit-group-2',
            elem: 'limit-rate',
            labelContent: [
                {
                    block: 'b-edit-group-2',
                    elem: 'limit-rate-label-keywords',
                    content: [
                        iget2('b-edit-group-2', 'maksimalnaya-stavka-za-tys', 'Максимальная ставка за тыс. показов для новых и измененных условий показа'),
                        {
                            block: 'b-help-link',
                            mods: {
                                type: 'modal'
                            },
                            stretched: true,
                            mix: [{
                                block: 'b-edit-group-2',
                                elem: 'help-icon'
                            }],
                            url: u.getHelpUrl('cpm-frontpage-maximum-bid')
                        }
                    ]
                },
                {
                    block: 'b-edit-group-2',
                    elem: 'limit-rate-label-crypta',
                    content: [
                        iget2('b-edit-group-2', 'maksimalnaya-stavka', 'Максимальная ставка'),
                        {
                            block: 'b-help-link',
                            mods: {
                                type: 'modal'
                            },
                            stretched: true,
                            mix: [{
                                block: 'b-edit-group-2',
                                elem: 'help-icon'
                            }],
                            url: u.getHelpUrl('cpm-frontpage-maximum-bid')
                        }
                    ]
                }
            ],
            price: group.general_limit_price || undefined,
            // realTime: 'no',
            targetText: iget2('b-edit-group-2', 'tys-pokazov-2', 'тысячу показов'),
            campDMParams: {
                name: 'dm-cpm-yndx-frontpage-campaign'
            },
            modelParams: {
                name: 'dm-cpm-yndx-frontpage-banner-group',
                id: group.modelId
            },
            currency: data.campaign.currency,
            errPath: 'auto_price'
        };
        var tags = {
            block: 'b-edit-group-2',
            elem: 'tags',
            tagsList: u.groupTags2.makeTagsArray(data.campaign.tags || [], group.tags || {}),
            modelName: 'dm-cpm-yndx-frontpage-banner-group',
            campaignName: 'dm-cpm-yndx-frontpage-campaign'
        };
        var groupContentBannerHeader = {
            mixes: {
                row: [
                    {
                        block: 'b-edit-group-2',
                        elem: 'group-properties-row'
                    }
                ]
            },
            control: {
                block: 'b-edit-group-2',
                attrs: {
                    id: 'Group-properties-' + this.group.modelId
                },
                elem: 'group-properties',
                content: iget2('b-edit-group-2', 'nastroyki-na-vsyu-gruppu', 'Настройки на всю группу')
            }
        };

        var settingsWithProfilesAndCryptaInventory = [
            // groupContentBannerHeader
            groupContentBannerHeader,
            // regions
            regions,
            // Условия показа по профилю пользователей только под фичей
            {
                block: 'b-edit-group-2',
                elem: 'display-conditions',
                isNewGroup: this.isNewGroup,
                isCopyGroup: this.isCopyGroup,
                cpmGroupType: group.cpmGroupType,
                selected: group.displayConditions
            },
            // Условия показа по профилю пользователей только под фичей
            {
                block: 'b-edit-group-2',
                elem: 'crypta',
                pid: group.pid,
                retargeting: retargetingInterests[0],
                errPath: 'targetInterests'
            },
            // limit-rate
            group.has_general_limit_price && limitRate,
            // tags
            this.data.tags_allowed == 'Yes' && tags
        ];

        var settingsWithCryptaInventory = [
            groupContentBannerHeader,
            {
                block: 'b-edit-group-2',
                elem: 'container',
                content: [
                    {
                        block: 'b-edit-group-2',
                        elem: 'controls',
                        content: apply('editLayout', {
                            mix: [
                                {
                                    block: 'b-edit-group-2',
                                    elem: 'grey-wrapper-controls',

                                }
                            ],
                            group: group,
                            groupContent: [
                                // regions
                                regions,
                                // limit-rate
                                group.has_general_limit_price && limitRate,
                                // tags
                                this.data.tags_allowed == 'Yes' && tags,
                            ]
                        }),
                    },
                    // right column
                    {
                        block: 'b-edit-group-2',
                        elem: 'right-column',
                        // crypta-inventory
                        content: {
                            block: 'b-edit-group-2',
                            elem: 'crypta-inventory',
                            pid: group.pid,
                            retargeting: retargetingInterests[0],
                            errPath: 'targetInterests'
                        }
                    }
                ]
            }
        ];

        return [
            applyNext(),
            apply('editLayout', {
                group: group,
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'banners-wrapper'
                },
                groupContent: groupContentBanners
            }),
            apply('editLayout', {
                group: group,
                groupContent: [{
                    block: 'b-edit-group-2',
                    elem: 'add-banner-button',
                    elemMods: {
                        type: 'new-error-display'
                    },
                    availableToCreateBannersCount: u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - group.banners_quantity,
                    mainTitle: iget2('b-edit-group-2', 'dobavit-banner', 'Добавить баннер'),
                    pluralTitles: [iget2('b-edit-group-2', 'obyavlenie', 'объявление'), iget2('b-edit-group-2', 'obyavleniya', 'объявления'), iget2('b-edit-group-2', 'obyavleniy', 'объявлений')],
                    errorPath: this.errorPath('banners')
                }]
            }),
            apply('editLayout', {
                mix: {
                    block: 'b-edit-group-2',
                    elem: 'grey-wrapper'
                },
                group: group,
                groupContent: hasEnabledFeatures('cpm_yndx_frontpage_profile') ? settingsWithProfilesAndCryptaInventory : settingsWithCryptaInventory
            })
        ];
    })

);
