BEM.DOM.decl({ name: 'b-edit-group-2', modName: 'type', modVal: 'cpm-yndx-frontpage-full' }, {

    _isReady: null,

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._cid = this.params.cid;
            this._adgroudId = this.model.get('adgroup_id') || '1'; // если мы на создании группы, у нас нет id
            this._reinitAdGroupPriceDebounced = $.debounce(this._reinitAdGroupPrice, 150, this);

            this._initGeneralLimitPrice(this.model)
                ._initGeneralLimitPriceGeoValidation();

            this.channel('cpm-yndx-frontpage-min-price').on(
                'group-' + this._adgroudId + '-inited',
                this._onAdGroupPriceInited,
                this
            );

            this._updateInventory();
        }
    },

    _reinitAdGroupPrice: function() {
        BEM.blocks['cpm-yndx-frontpage-min-price'].initGroupsMinPrice(
            this._cid,
            [{
                geo: this.model.getGeoModel().get('geo'),
                price: this.model.get('general_limit_price'),
                adgroup_id: this._adgroudId
            }]
        );
    },

    /**
     * Обработчик инициализации ставок для текущей группы
     * @private
     */
    _onAdGroupPriceInited: function() {
        var adGroupValidationRes = BEM.blocks['cpm-yndx-frontpage-min-price'].getGroupValidationResults([
            this._cid,
            this._adgroudId
        ]);

        if ((adGroupValidationRes.warnings || []).length) {
            this._showPriceWarnings(adGroupValidationRes.warnings);
        } else {
            this._cleanupFrontpageGeoWarnings();
        }

        this._getGeneralLimitPrice() && this._getGeneralLimitPrice().lazyValidate();
    },

    _initGeneralLimitPriceGeoValidation: function() {
        if (this._getGeneralLimitPrice()) {
            this._getSubscriptionManager().wrap(this.model)
                .on('general_limit_price', 'change', this._reinitAdGroupPriceDebounced, this);

            this._getSubscriptionManager().wrap(this.model.getGeoModel())
                .on('geo', 'change', this._reinitAdGroupPriceDebounced, this);
        }

        return this;
    },

    /**
     * Отрисовываем предупреждения полученные в ходе валидации ставки
     * @param {Array} warnings - предупреждения в стандартном JAVA формате
     * @private
     */
    _showPriceWarnings: function(warnings) {
        var serverWarnings = warnings.map(function(warn) {
            var storeArg = [
                { backendParams: warn.params || {} },
                'cpm-yndx-frontpage',
                warn.code
            ];

            return BEMHTML.apply({
                block: 'b-edit-group-2',
                elem: 'general-limit-price-warning',
                content: u['text-store'].get.apply(u['text-store'], storeArg)
            });
        });

        BEM.DOM.update(this.elem('general-limit-price-warnings'), serverWarnings);
    },

    /**
     * Очистка предупреждений
     * @private
     */
    _cleanupFrontpageGeoWarnings: function() {
        BEM.DOM.update(this.elem('general-limit-price-warnings'), '');
    },

    /**
     * Возвращает значение флага
     * @returns {boolean}
     */
    isReady: function() {
        return !!this._isReady;
    },

    /**
     * Инициализирует связи блока 'Условия подбора аудиторий' с моделью группы
     * @private
     */
    _initRetargeting: function() {
        // не у всех типов кампаний есть 'Условия подбора аудиторий'
        if (!this._getCryptaSettingsBlock()) {
            this._isReady = true;
            this.trigger('ready');
            return;
        }

        this._getSubscriptionManager().wrap(this._getCryptaSettingsBlock())
            .on('conditions:add', function(event, data) {
                this.model.get('retargetingsInterests').add(data.model);
            }, this)
            .on('ready', function() {
                this._isReady = true;
                this.trigger('ready');
            }, this);

        this._getSubscriptionManager().wrap(this.model)
            .on('retargetingsInterests banners','change', this._updateInventory, this);

        this._getSubscriptionManager().wrap(this.model.getGeoModel())
            .on('geoText','change', this._updateInventory, this);
    },

    /**
     * @override {b-edit-group-2}
     */
    _getNewBannerModel: function(defaults) {
        var newBannerData = u._.extend({}, defaults);

        return this.model.addBanner(newBannerData);
    },

    /**
     * @override {b-edit-group-2}
     */
    _onBeforeBannerAdd: function(bannerModel) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') + 1);
    },

    /**
     * @override {b-edit-group-2}
     */
    _onBeforeBannerRemove: function(bannerId) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') - 1);
    },

    /**
     * @override {b-edit-group-2}
     */
    _getAvailableToCreateBannersCount: function() {
        return u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - this.model.get('banners_quantity');
    },

    /**
     * @override {b-edit-group-2}
     */
    _updateCountInBlocks: function(available) {
        this._banners
            .forEach(function(banner) {
                banner.updateAvailableBannerCount(available);
            });
    },

    _removeBanner: function() {
        this.__base.apply(this, arguments);

        this.findBlocksInside('b-edit-banner2').forEach(function(block, index) {
            block.domElem.attr('data-err-path', index.toString());
        });
    },

    /**
     * @override {b-edit-group-2}
     */
    _getEditBlockBemjson: function(bannerModel) {
        var bannerData = bannerModel.provideData(),
            bannerIndex = this.model.get('banners').length() - 1;

        return u._.extend({}, this.params.newBannerData, {
            block: 'b-edit-banner2',
            mods: {
                type: 'cpm-yndx-frontpage',
                'cpm-yndx-frontpage-group-type': this.getMod('cpm-yndx-frontpage-group-type')
            },
            attrs: { 'data-err-path': '' + bannerIndex },
            canDelete: true,
            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
            banner: bannerData,
            group: u._.extend(
                this.model.provideData(),
                {
                    modelId: this.model.id,
                    cpmGroupType: this.model.get('cpmGroupType')
                }
            ),
            campaign: this.model.getCampaignModel().toJSON(),
            noModelData: true,
            modelParams: {
                name: bannerModel.name,
                id: bannerModel.id,
                parentModel: this.model
            },
            availableBannerCount: this._getAvailableToCreateBannersCount(),
            errorPath: this._errorPathBuilder(this.model.get('banners_quantity') - 1) // визуальные индексы на 1 больше индексов для ошибок
        });
    }

});
