BEM.DOM.decl({ name: 'b-edit-group-2', modName: 'type', modVal: 'text-full' }, {

    onSetMod: {
        js: function() {
            var login = this.params.login,
                cid = this.params.cid,
                isNewGroup = this.params.isNewGroup;

            this.__base.apply(this, arguments);

            this._initGeneralLimitPrice(this.model);

            // не загружаем рекомендацию для новых групп
            if (!isNewGroup) {
                u['b-turbo-landings-selector'].getTurboRecommendation(login, cid, this.model);
            }
        }
    },

    /**
     * @override {b-edit-group}
     */
    _additionalInit: function() {
        this.__base.apply(this, arguments);

        var tumbler = this.findBlockInside('relevance-match-tumbler', 'tumbler');

        tumbler && this._getSubscriptionManager()
            .on(tumbler, 'change', function(e, data) {
                this.model.set('has_relevance_match', data.value == 'true');
            }, this);

        if (this.params.isNewGroup && u.consts('isRelevanceMatchForNewGroupsEnabledByDefault')) {
            tumbler.val('true');
        }
    },

    /**
     * @override {b-edit-group}
     */
    _getNewBannerModel: function(defaults) {
        var newBannerData = u._.extend({}, defaults);

        if (this.params.hasMediaResources && this.params.isAutoVideoOn) {
            this._mediaExtensionsDataProvider = this._mediaExtensionsDataProvider ||
                BEM.create('i-banner-media-extensions-data', { resources: this._bannerMediaResources });

            // для новых баннеров видео по умолчанию уже создано
            u._.extend(newBannerData, {
                video_resources: this._mediaExtensionsDataProvider.getVideo()
            });
        }

        return this.model.addBanner(newBannerData);
    },

    /**
     * @override {b-edit-group}
     */
    _onBeforeBannerAdd: function(bannerModel) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') + 1);
    },

    /**
     * @override {b-edit-group}
     */
    _onBeforeBannerRemove: function(bannerId) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') - 1);
    },

    /**
     * @override {b-edit-group}
     */
    _getAvailableToCreateBannersCount: function() {
        return u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - this.model.get('banners_quantity');
    },

    /**
     * @override {b-edit-group}
     */
    _updateCountInBlocks: function(available) {
        this._banners
            .forEach(function(banner) {
                banner.updateAvailableBannerCount(available);
            });
    },

    _removeBanner: function() {
        this.__base.apply(this, arguments);

        this.findBlocksInside('b-edit-banner2').forEach(function(block, index) {
            block.domElem.attr('data-err-path', index.toString());
        });
    },

    /**
     * @override {b-edit-group}
     */
    _getEditBlockBemjson: function(bannerModel) {
        var bannerData = bannerModel.provideData(),
            bannerIndex = this.model.get('banners').length() - 1;

        return u._.extend({}, this.params.newBannerData, {
            block: 'b-edit-banner2',
            mods: { type: 'text2' },
            attrs: { 'data-err-path': '' + bannerIndex },
            canDelete: true,
            bannerIndex: bannerIndex,
            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
            banner: bannerData,
            group: u._.extend(this.model.provideData(), { modelId: this.model.id }),
            campaign: this.model.getCampaignModel().toJSON(),
            noModelData: true,
            modelParams: {
                name: bannerModel.name,
                id: bannerModel.id,
                parentModel: this.model
            },
            withMobile: this.params.withMobile,
            availableBannerCount: this._getAvailableToCreateBannersCount(),
            errorPath: this._errorPathBuilder(bannerData.newBannerIndex),
            clientId: this.params.clientId,
            isTurboLandingEnabled: this.params.isTurboLandingEnabled,
            lang: this.params.lang
        });
    }
});
