block('b-edit-group-2')(

    def()(function() {
        apply('setModel');

        return applyNext({
            errorPath: u.error.createPathBuilder(this.ctx.errorPath)
        });
    }),

    mode('setModel')(function() {
        var group = this.ctx.group;

        if (!group.group_name) group.group_name = iget2('b-edit-group-2', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

        this.groupModelName = 'm-group';
        this.group = group;
        this.isSingleGroup = this.ctx.isSingleGroup;
        this.firstBanner = this.ctx.firstBanner;
        this.prevBanner = this.ctx.prevBanner;
        this.errors = group.errors || {};
        this.groupIndex = this.ctx.groupIndex;
        this.groupId = this.group.modelId;
        this.campaign = this.ctx.campaign;
    }),

    js()(function() {
        return {
            login: u.consts('ulogin'),
            modelName: this.groupModelName,
            modelId: this.groupId,
            cid: this.data.campaign.cid,
            newBannerData: {
                hasHeaderActions: this.mods.type == 'text-full',
                withVCard: this.group.withVCard,
                canEditDomain: this.ctx.canEditDomain,
                isCopyGroup: this.ctx.isCopyGroup,
                isNewGroup: this.ctx.isNewGroup,
                isSingleGroup: this.ctx.isSingleGroup,
                groupIndex: this.ctx.groupIndex,
                promoCodeDomains: this.ctx.promoCodeDomains
            },
            withMobile: true,
            errorPath: this.ctx.errorPath,
            isAutoVideoOn: this.ctx.isAutoVideoOn,
            hasMediaResources: this.ctx.hasMediaResources,
            showRegionsPopup: this.data.FORM.showRegionsPopup,
            clientId: this.ctx.clientId,
            isTurboLandingEnabled: this.ctx.isTurboLandingEnabled,
            isIndoorSegmentsEnabled: hasEnabledFeatures('indoor_segments'),
            isNewGroup: this.group.isNewGroup,
            lang: this.ctx.lang
        };
    }),

    mode('editLayout')(function() {
        return {
            block: 'b-layout-form',
            mods: {
                inner: 'yes'
            },
            mix: this.mix,
            mixes: {
                row: [{
                    block: 'b-edit-group-2',
                    elem: 'row'
                }],
                label: [{
                    block: 'b-edit-group-2',
                    elem: 'label'
                }],
                control: [{
                    block: 'b-edit-group-2',
                    elem: 'control',
                    elemMods: { 'read-only': this.readOnly ? 'yes' : '' }
                }],
                info: [{
                    block: 'b-edit-group-2',
                    elem: 'info'
                }]
            },
            rows: applyCtx(this.groupContent.reduce(function(acc, row) {
                return acc.concat(row);
            }, []))
        };
    }),

    content()({
        elem: 'group-data'
    }),

    elem('group-data').content()(function() {
        var group = this.group;

        return [
            {
                block: 'i-model',
                modelParams: {
                    name: 'm-geo-regions',
                    parentName: this.groupModelName,
                    id: this.groupId,
                    parentId: this.groupId,
                    data: {
                        geo: group.geo,
                        geo_names: group.geo_names
                    }
                }
            }
        ];
    })
);
