BEM.DOM.decl('b-edit-group-2', {
    onSetMod: {
        js: function() {
            var regionsSelectorBlock = this.findBlockInside('b-regions-selector');

            this.model = BEM.MODEL.getOrCreate({ name: this.params.modelName || 'm-group', id: this.params.modelId });

            this._errorPathBuilder = u.error.createPathBuilder(this.params.errorPath + '.banners');

            u.graspSelf.call(this, {
                _addBannerButton: '? b-edit-banner-add2 inside add-banner',
                groupName: '? input on group-name-input'
            });

            if (this.groupName) {
                this.groupName.on('change', function() {
                    this.model.set('group_name', this.groupName.val());
                }, this);

                this.model.on('group_name', 'change', function() {
                    if (this.groupName.hasMod('focused')) return;

                    this.groupName.val(this.model.get('group_name'));
                }, this);
            }

            if (this._addBannerButton) {
                this._getSubscriptionManager().on(this._addBannerButton, 'add', function(e) {
                    this._onBannerAddRequest();
                }, this);
            }

            this._banners = this.findBlocksInside('b-edit-banner2');

            this._getSubscriptionManager().wrap(BEM.blocks['b-edit-banner2'])
                .on(this.domElem, 'new:banners:needed', function(e, banners) {
                    banners.forEach(function(banner) {
                        var newBanner = this._getNewBannerModel(banner);

                        this._addBanner(newBanner);
                    }, this);
                }, this)
                .on(this.domElem, 'remove', function(e, data) {
                    this._onBannerRemoveRequest(data.model.id);
                }, this);

            this._additionalInit();

            if (this.params.showRegionsPopup && regionsSelectorBlock) {
                regionsSelectorBlock.domElem[0].scrollIntoView();
                regionsSelectorBlock.openRegionsPopup();
            }
        }
    },

    /**
    * Поставляет. данные групп в виде хэша
    * @returns {Object}
    */
    provideData: function() {
        return this.model.provideData();
    },

    /**
     * Определяет все возможные медиадополнения для баннера
     * @param {Object} resources
     */
    setBannerMediaResources: function(resources) {
        if (!this.params.hasMediaResources) {
            return;
        }

        this._bannerMediaResources = resources;

        this._banners.forEach(function(banner) {
            banner.setMediaResources(this._bannerMediaResources);
        }, this);
    },

    /**
     * @override {BEM.DOM}
     */
    destruct: function() {
        this._getSubscriptionManager().dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Инициализация зависимых блоков
     */
    _additionalInit: function() {
        this._initRetargeting();
    },

    /**
     * Возвращает менеджер подписок
     * @returns {Object}
     * @private
     */
    _getSubscriptionManager: function() {
        return this._subscriptionManager || (this._subscriptionManager = BEM.create('i-subscription-manager'));
    },

    /**
     * Создает и возвращает модель нового баннера
     * @param {Object} defaults - данные по умолчанию
     * @returns {BEM.MODEL}
     * @private
     */
    _getNewBannerModel: function(defaults) {
        return this.model.addBanner(defaults);
    },

    /**
     * Реакция на нажатие кнопки добавления нового баннера
     */
    _onBannerAddRequest: function() {
        var newBanner = this._getNewBannerModel();

        this._addBanner(newBanner);
    },

    /**
     * Реакция на нажатие кнопки удаления баннера
     * @param {String} bannerId
     */
    _onBannerRemoveRequest: function(bannerId) {
        this.model.removeBanner(bannerId);
        this._removeBanner(bannerId);
    },

    /**
     * Колбек выполняемый перед добавлением баннера
     * @param {BEM.MODEL} bannerModel
     */
    _onBeforeBannerAdd: function(bannerModel) {},

    /**
     * Колбек выполняемый перед удалением баннера
     * @param {String} bannerId
     */
    _onBeforeBannerRemove: function(bannerId) {},

    /**
     * Колбек, выполняемый после добавления баннера в dom
     * @param {b-edit-banner-add2} block
     */
    _onAfterBannerAdd: function(block) {
        $(window).trigger('scroll'); // чтобы открытые тултипы перерисовались
        if (this.params.hasMediaResources) {
            block.setMediaResources(this._bannerMediaResources);
        }
    },

    /**
     * Возвращает количество объявлений, которые можно создать в группе
     * @returns {Number}
     */
    _getAvailableToCreateBannersCount: function() {
        throw new Error('must be implemented in subclass');
    },

    /**
     * Отрисовывает новый баннер в конце списка
     * @param {BEM.MODEL} bannerModel
     */
    _addBanner: function(bannerModel) {
        var bannerRow,
            newBannerBlock;

        this._onBeforeBannerAdd(bannerModel);
        this._updateBannersCount();
        bannerRow = BEM.DOM.append(this._getBannersListContainer(), this._buildBannerRow(bannerModel));
        newBannerBlock = this.findBlockInside(bannerRow, 'b-edit-banner2');
        this._onAfterBannerAdd(newBannerBlock);
    },

    /**
     * Удаляет из dom-а баннер с указанным идентификатором
     * @param {String} bannerId
     */
    _removeBanner: function(bannerId) {
        this._onBeforeBannerRemove(bannerId);
        this._updateBannersCount();
        BEM.DOM.destruct(this.findElem('banner-row', 'banner-id', bannerId));

        $(window).trigger('scroll'); // чтобы открытые тултипы перерисовались
    },

    /**
     * Обновляет отображаемое количество объявлений
     */
    _updateBannersCount: function() {
        var enableToCreateCount = this._getAvailableToCreateBannersCount();

        this._updateCountInBlocks(enableToCreateCount);
        this._addBannerButton.setAvailableToCreateBannersCount(enableToCreateCount);
    },

    /**
     * Передает внутренним блокам новое доступное для добавления количество баннеров
     * (этот метод перелпределяется в модификаторах)
     * @param {Number} count - доступное для добавления количество баннеров
     * @private
     */
    _updateCountInBlocks: function(count) { },

    /**
     * Возвращает BEMJSON блока редактирования баннера
     * @param {Object} bannerData данные баннера
     * @returns {BEMJSON}
     */
    _getEditBlockBemjson: function(bannerData) {
        throw new Error('must be implemented in subclass');
    },

    /**
     * Возвращает html элемента - строки с баннером
     * @param {BEM.MODEL} bannerModel
     * @returns {String} html результата
     */
    _buildBannerRow: function(bannerModel) {
        return BEMHTML.apply({
            block: 'b-edit-group-2',
            elem: 'row',
            mix: [
                { block: 'b-layout-form', elem: 'row' },
                { block: 'b-edit-group-2', elem: 'banner-row', elemMods: { 'banner-id': bannerModel.id } }
            ],
            content: this._getEditBlockBemjson(bannerModel)
        });
    },

    /**
     * Возвращает контейнер списка баннеров
     * @returns {$}
     */
    _getBannersListContainer: function() {
        return this.elem('banners-list');
    },

    /**
     * Инициализирует контрол для фидов
     * Нужно только в типах групп у которых есть фиды
     * Сейчас фиды есть в динамических объявления и в смарт-баннерах
     * @private
     */
    _initFeeds: function() {
        u.graspSelf.call(this, {
            _feed: 'b-group-feed on feed',
            _filters: 'b-feed-filters on filters'
        });

        //фильтры нужно актуализировать после групповых изменений
        BEM.blocks['b-edit-groups-mass-actions'].on('filters-mass-actions:completed', function() {
            this._filters.actualizeFilters();
        }, this);

        this._feed.on('change', function(e, data) {
            var action = function() {
                    var isDisabled = data.feed_id == 0;

                    this._filters.setMod('state', isDisabled ? 'disabled' : '');
                    this._updateBannersCount();
                    this._addBannerButton && this._addBannerButton.hasMod('limits', 'feed') &&
                        this._addBannerButton.setSelectedFeeds(!isDisabled);

                    this.model.set('feed_id', data.feed_id);
                }.bind(this),
                selectedBusinessType = BEM.MODEL.getOne({
                    name: 'dm-dynamic-media-feed',
                    id: data.feed_id
                }).get('business_type'),
                selectedFeedType = BEM.MODEL.getOne({
                    name: 'dm-dynamic-media-feed',
                    id: data.feed_id
                }).get('feed_type');

            if (data.prev_feed_id && !this._reverting &&
                (this.model.isAnyFeedFilter() || this._hasBannersToDelete(selectedBusinessType))) {

                var currentBusinessType = BEM.MODEL.getOne({
                        name: 'dm-dynamic-media-feed',
                        id: data.prev_feed_id
                    }).get('business_type'),
                    currentFeedType = BEM.MODEL.getOne({
                        name: 'dm-dynamic-media-feed',
                        id: data.prev_feed_id
                    }).get('feed_type');

                BEM.blocks['b-confirm'].open({
                    message: this._getFeedsConfirmText(selectedBusinessType, currentBusinessType),
                    onYes: function() {
                        action();
                        if (selectedFeedType === 'YandexMarket' && currentFeedType === 'YandexMarket') {
                            this.model.rebaseFilters().then(function() {
                                this._filters.actualizeFilters();
                            }.bind(this));
                        } else {
                            if (this.model.get('adgroup_type') === 'performance') {
                                this.model.toJSON()['banners'].forEach(function(banner) {
                                    this._removeBanner(banner['modelId']);
                                }, this);
                            }

                            this._filters.clearFilters();
                        }

                    },
                    onNo: function() {
                        this._reverting = true;
                        this._feed.select(data.prev_feed_id);
                        this._reverting = false;
                        action();
                    }
                }, this);
            } else {
                action();
            }
        }, this);
    },

    /**
     * Проверка на наличие баннеров, которые будут удалены при смене фида
     * @param {String} selectedBusinessType - новый тип бизнеса
     * @returns {Boolean}
     * @private
     */
    _hasBannersToDelete: function(selectedBusinessType) {
        var banners = this.model.toJSON()['banners'],
            hasBannersToDelete = false;

        if (banners.length && this.model.get('adgroup_type') !== 'dynamic') {
            hasBannersToDelete = banners.some(function(banner) {
                return u._.get(banner, 'creative.business_type') !== selectedBusinessType;
            });
        }

        return hasBannersToDelete;
    },

    /**
     * Формирование сообщения для конфирма
     * @param {String} selectedBusinessType - текущий тип бизнеса
     * @param {String} currentBusinessType - новый тип бизнеса
     * @returns {String}
     * @private
     */
    _getFeedsConfirmText: function(selectedBusinessType, currentBusinessType) {
        var text;

        if (selectedBusinessType == currentBusinessType) {
            text = iget2('b-edit-group-2', 'filtry-v-gruppe-budut', 'Фильтры в группе будут изменены. Вы действительно хотите изменить фид?');
        } else if (selectedBusinessType != currentBusinessType) {
            if (this.model.get('adgroup_type') === 'performance') {
                text = iget2(
                    'b-edit-group-2',
                    'v-gruppe-budut-udaleny',
                    'В группе будут удалены фильтры и смарт-баннеры, которые не соответствуют типу бизнеса выбранного фида. Вы действительно хотите изменить фид?'
                );
            } else if (this.model.get('adgroup_type') === 'dynamic') {
                text = iget2(
                    'b-edit-group-2',
                    'v-gruppe-budut-udaleny-109',
                    'В группе будут удалены фильтры, которые не соответствуют типу бизнеса выбранного фида. Вы действительно хотите изменить фид?'
                );
            }
        }

        return text;
    },

    /**
     * Инициализирует связи блока 'Условия подбора аудиторий' с моделью группы
     * @private
     */
    _initRetargeting: function() {
        var groupRetargetingBlock = this.findBlockInside('b-group-retargeting2');

        // не у всех типов кампаний есть 'Условия подбора аудиторий'
        if (!groupRetargetingBlock) {
            return;
        }

        this._getSubscriptionManager().wrap(this.model).on('retargetingsIds', 'change', function() {
            groupRetargetingBlock.renderConditions(this.model.get('retargetingsIds'));
        });

        this._getSubscriptionManager()
            .wrap(groupRetargetingBlock)
            .on('conditions:update', this._updateRetargetingConditions, this);
    },

    /**
     * Обновляет условия ретаргетинга для группы
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _updateRetargetingConditions: function(e, data) {
        var savedRetIds = this.model.get('retargetingsIds');

        this.model.set('retargetingsIds', data.conditions.map(function(condition) {
            // ищем условие среди уже сохраненных или создаем новое, у которого все данные кроме ret_cond_id пустые
            return u._.find(savedRetIds, function(item) {
                return item.ret_cond_id === condition.ret_cond_id;
            }) || condition;
        }));
    },

    /**
     * Задает модель блоку b-edit-phrase-price
     * @param {BEM.MODEL} model - модель группы
     * @private
     */
    _initGeneralLimitPrice: function(model) {
        if (this._getGeneralLimitPrice()) {
            this._getGeneralLimitPrice().initModels([model]);
        }

        return this;
    },

    /**
     * Возвращает инстанс блока «Ограничение ставки»
     * @returns {BEM}
     * @private
     */
    _getGeneralLimitPrice: function() {
        return this._generalLimitPrice ||
            (this._generalLimitPrice = this.findBlockInside('general-limit-price', 'b-edit-phrase-price'));
    },

    /**
     * Возвращает инстанс блока для отображения ощибок валидации «Ограничение ставки»
     * @returns {BEM}
     * @private
     */
    _getGeneralLimitPriceError: function() {
        return this._generalLimitPriceError ||
            (this._generalLimitPriceError = this.findBlockInside('general-limit-price-error', 'b-error-message'));
    },

    /**
     * Возвращает инстанс селекта «Тип объявлений»
     * @returns {BEM}
     * @private
     */
    _getCpmGroupTypeSelector: function() {
        return this._groupTypeSelector ||
            (this._groupTypeSelector = this.findBlockOn('cpm-group-type-selector', 'select2'));
    },

    /**
     * Подписывается на события измения типа группы
     * @returns {BEM}
     * @private
     */
    _initCpmGroupTypeSelector: function() {
        if (this._getCpmGroupTypeSelector()) {
            this._getSubscriptionManager()
                .on(this._getCpmGroupTypeSelector(), 'change', this._onCpmGroupTypeSelectorChange, this)
                .on(this.model, 'cpmGroupType', 'change', this._onCpmGroupTypeChange, this);
        }

        return this;
    },

    /**
     * Меняет тип группы в модели, показывает конфирм если есть конфликты
     * @param {Event} e
     * @param {Object} data
     * @returns {BEM}
     * @private
     */
    _onCpmGroupTypeSelectorChange: function(e, data) {
        var newCpmGroupType = data.currVal,
            isResetBannersMode = this.model.get('isResetBannersMode'),
            warnings = isResetBannersMode ? {} : this._getCpmGroupTypeWarnings(newCpmGroupType),
            availableConditions,
            retModel = this.model.get('retargetingsInterests').getByIndex(0);

        // удаляем жанры из модели
        if (data.prevVal === 'cpm_audio') {
            retModel.set('audio-genres', [])
        }

        // возвращаем ранее выбранные жанры в модель
        if (data.currVal === 'cpm_audio') {
            this.trigger('setAudioType');
        }

        if (isResetBannersMode) {
            this.model.set('isResetBannersMode', false);
        }

        if (u._.isEmpty(warnings)) {
            availableConditions = u.campaign.getCpmGroupDisplayConditions(newCpmGroupType);

            this.model.set('cpmGroupType', newCpmGroupType);

            if (availableConditions.indexOf(this.model.get('displayConditions')) === -1) {
                this.model.set('displayConditions', availableConditions[0]);
            }

        } else {
            BEM.blocks['b-user-dialog'].confirm({
                message: {
                    block: 'b-edit-group',
                    elem: 'dialog-content',
                    content: [
                        iget2('b-edit-group', 'pay-attention', 'Обратите внимание:'),
                        {
                            block: 'b-menu',
                            mods: { layout: 'vert' },
                            mix: { block: 'b-edit-group', elem: 'pay-attention-messages' },
                            content: u._.keys(warnings).map(function(name) {
                                return {
                                    elem: 'item',
                                    content: warnings[name].text
                                };
                            })
                        }
                    ]
                },
                confrimButtonText: iget2('b-edit-group', 'ok', 'Ок'),
                cancelButtonText: iget2('b-edit-group', 'otmena', 'Отмена'),
                onConfirm: function() {
                    this.model.set('cpmGroupType', newCpmGroupType);

                    // меняем условие показа на доступное
                    if (warnings.displayCondition) {
                        this.model.set('displayConditions', warnings.displayCondition.available);
                    }
                },
                onCancel: function() {
                    // нужно вернуть ранее выбранные креативы без валидации
                    this.model.set('isResetBannersMode', true);

                    this._getCpmGroupTypeSelector()
                        .setVal(data.prevVal);
                },
                callbackCtx: this
            });
        }

        return this;
    },

    /**
     * Возвращает кофликты текущего и нового типа группы
     * @param {String} newCpmGroupType - новый тип группы
     * @returns {Object}
     * @private
     */
    _getCpmGroupTypeWarnings: function(newCpmGroupType) {
        var warnings = {},
            displayCondition = this.model.get('displayConditions'),
            availableConditions = u.campaign.getCpmGroupDisplayConditions(newCpmGroupType);

        // «Условия показа»
        if (availableConditions.indexOf(displayCondition) === -1 &&
            this.model.isCpmGroupConditionChanged(displayCondition)) {

            switch (newCpmGroupType + '_' + displayCondition) {
                case 'cpm_indoor_keywords':
                case 'cpm_outdoor_keywords':
                case 'cpm_video_keywords':
                    warnings.displayCondition = {
                        available: 'crypta',
                        text: iget2(
                            'b-edit-group',
                            'keywords-cant-be-used-in-video-group',
                            'Ключевые фразы нельзя использованы в группе с видео объявлениями, они будут заменены на профиль пользователей.'
                        )
                    };
                    break;
                case 'cpm_audio_keywords':
                    warnings.displayCondition = {
                        available: 'crypta',
                        text: iget2(
                            'b-edit-group',
                            'keywords-cant-be-used-in-audio-group',
                            'Ключевые фразы нельзя использованы в группе с аудио объявлениями, они будут заменены на профиль пользователей.'
                        )
                    };
            }
        }

        // Типы креативов
        if (this.model.getConflictCreatives(newCpmGroupType).length) {
            warnings.creative = {
                text: iget2('b-edit-group', 'selected-creatives-will-be-reset', 'Выбранные креативы будут сброшены.')
            }
        }

        return warnings;
    },

    /**
     * Меняет модификатор объявлений, дизейблит условие показа если оно единственное
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onCpmGroupTypeChange: function(e, data) {
        var modType = u.beminize(data.value),
            availableConditions = u.campaign.getCpmGroupDisplayConditions(data.value);

        this._getDisplaySelector()
            .toggleMod('disabled', 'yes', availableConditions.length < 2);

        this.setMod('cpm-group-type', modType)
            .findBlocksInside('b-edit-banner2')
            .forEach(function(banner) {
                banner.setMod('cpm-group-type', modType);
            });
    },

    _getCryptaSettingsBlock: function() {
        if (!this._cryptaSettingsBlock) {
            this._cryptaSettingsBlock =
                this.findBlockInside('b-crypta-settings') || this.findBlockInside('b-crypta-inventory');
        }
        return this._cryptaSettingsBlock;
    },

    /**
     * Обновляет данные для блока прогноза
     * @private
     */
    _updateInventory: function() {
        var cryptaSettingsBlock = this._getCryptaSettingsBlock();

        if (cryptaSettingsBlock) {
            cryptaSettingsBlock
                .delMod('predictor-loading')
                .setMod('predictor-loading', 'yes');

            return this
                ._getCryptaInventoryBanners()
                .then(this._getDataForCryptaInventory.bind(this))
                .then(function(inventory) {
                    if (cryptaSettingsBlock.updateInventory) cryptaSettingsBlock.updateInventory(inventory);
                    if (cryptaSettingsBlock.update) cryptaSettingsBlock.update(inventory);
                }.bind(this))
                .fail(function(eventName) {
                    if (eventName !== 'abort') {
                        cryptaSettingsBlock.delMod('predictor-loading');

                        BEM.blocks['b-user-dialog']
                            .alert(iget2(
                                'b-edit-group-2',
                                'text-сrypta-шnventory-error',
                                'Ошибка прогнозирования. Попробуйте ещё раз.'
                            ));

                    }
                }.bind(this));
        }
    },

    /**
     * @typedef {Object} PredictParams
     *
     * @property {String} adgroup_id - ид группы
     * @property {String} campaign_id - ид кампании
     * @property {Object} geo - информация о геопозиции
     * @property {String} geo.ids - ид регионов
     * @property {String} geo.text - текстовое представление регионов
     * @property {Array<RetConditionGroup>} interests - формула сегментов
     * @property {Array<Object>} banners - размеры баннеров или длительность видео
     */

    /**
     * Формирует данные для блока прогноза
     * @returns {PredictParams}
     * @private
     */
    _getDataForCryptaInventory: function(banners) {
        var model = this.model,
            retModel = model.get('retargetingsInterests').getByIndex(0),
            modelData = model.toJSON(),
            corrections = {},
            multipliersData = model.getMultipliersData(),
            multipliersDesktop = u._.get(multipliersData, 'desktop_multiplier.multiplier_pct'),
            multipliersMobile = u._.get(multipliersData, 'mobile_multiplier.multiplier_pct'),
            multipliersMobileOs = u._.get(multipliersData, 'mobile_multiplier.os_type');

        if (!u._.isUndefined(multipliersMobile)) {
            corrections.mobile = multipliersMobile;

            if (multipliersMobileOs) {
                corrections.mobile_os_type = multipliersMobileOs;
            }
        }
        if (!u._.isUndefined(multipliersDesktop)) {
            corrections.desktop = multipliersDesktop;
        }

        return {
            adgroup_id: modelData.adgroup_id,
            campaign_id: model.getCampaignModel().get('cid'),
            has_adaptive_creative: model.get('hasAnyAdaptiveCreatives') || false,
            geo: {
                ids: model.getGeoModel().get('geo'),
                text: model.getGeoModel().get('geoText')
            },
            interests: retModel ? retModel.toJSON().groups : [],
            cpmGroupType: model.get('cpmGroupType'),
            banners: banners,
            corrections: corrections
        };
    },

    _getCryptaInventoryBanners: function() {
        var banners = this.model.get('banners'),
            videoIds;

        switch (this.model.get('cpmGroupType')) {
            case 'cpm_audio': return $.Deferred().resolve([]).promise();
            case 'cpm_video':
                videoIds = u._.compact(
                    this.model.get('banners').map(function(banner) {
                        return banner.get('creative').get('creative_id');
                    })
                );

                return u._.isEmpty(videoIds) ? $.Deferred().resolve([]).promise() : this._getBannersVideoData(videoIds);
            case 'cpm_banner': // jshint ignore:line
            default:
                return $.Deferred().resolve(
                    banners
                        .map(function(banner) {
                            var creative = banner.get('creative');

                            return {
                                width: creative.get('width'),
                                height: creative.get('height'),
                                isAdaptive: creative.get('is_adaptive') === '1'
                            };
                        })
                        .filter(function(banner) { return !!(banner.height && banner.width); })
                ).promise();
        }
    },

    _videoCreativesCache: null,

    _getBannersVideoData: function(creativeIds) {
        var _this = this,
            deferred = $.Deferred();

        if (this._videoCreativesRequest) {
            this._videoCreativesRequest.abort();
        }

        this._videoCreativesCache || (this._videoCreativesCache = {});
        // экономим на запросе информации о видео креативе
        if (creativeIds.every(this._hasCachedCreative, this)) {
            return deferred.resolve(
                this._getUniqDurationCreatives(
                    creativeIds.map(function(id) {
                        return this._videoCreativesCache[id];
                    }, this)
                )
            ).promise();
        }

        this._getVideoCreativesRequest()
            .get({
                ulogin: u.consts('ulogin') || '',
                cmd: 'searchVideoCreatives',
                creative_id: creativeIds.join(',')
            }, function(data) {
                _this._videoCreativesRequest = null;

                deferred.resolve(
                    _this._getUniqDurationCreatives(
                        data.result.creatives.map(function(creative) {
                            // кэшируем информацию о видео креативе
                            return _this._videoCreativesCache[creative.creative_id] = {
                                ration: creative.ration,
                                duration: creative.duration
                            }
                        })
                    )
                );
            }, function(event, eventName) {
                deferred.reject(eventName);
            });

        return deferred.promise();
    },

    _hasCachedCreative: function(id) {
        return this._videoCreativesCache[id];
    },

    _videoCreativesRequest: null,

    _getVideoCreativesRequest: function() {
        return this._videoCreativesRequest || (this._videoCreativesRequest = BEM.create('i-request_type_ajax', {
            url: u.consts('SCRIPT'),
            dataType: 'json',
            type: 'POST',
            cache: false
        }));
    },

    /**
     * Возвращает креативы с уникальной длительностью
     * @param {Object} creatives
     * @returns {*}
     * @private
     */
    _getUniqDurationCreatives: function(creatives) {
        var uniqDuration = {};

        return creatives.filter(function(creative) {
            if (!uniqDuration[creative.duration]) {
                return uniqDuration[creative.duration] = true;
            }

            return false;
        });
    },

    _onAdjustmentRatesChange: function() {}

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('save', 'b-adjustment-rates-popup', function() {
            this._onAdjustmentRatesChange();
        });

        return false;
    }

});
