block('b-edit-group-header')(
    mix()({
        block: 'b-edit-group',
        elem: 'row'
    }),

    elem('label').content()(function() {
        return [
            {
                elem: 'inner-row',
                elemMods: { 'title-row': 'yes' },
                content: iget2('b-edit-group-header', 'group', 'Группа')
            },
            {
                elem: 'label-content',
                content: [
                    iget2('b-edit-group-header', 'nazvanie-gruppy', 'Название группы'),
                    {
                        block: 'b-mark-required',
                        mix: {
                            block: 'b-edit-group-header',
                            elem: 'required'
                        }
                    }
                ]
            }
        ];
    }),

    elem('control').content()(function() {
        return [
            {
                elem: 'inner-row',
                content: {
                    elem: 'group-number',
                    content: '№ ' + this.ctx.groupNumber
                }
            },
            this.ctx.errorPath && {
                block: 'b-error-message',
                js: { path: this.ctx.errorPath }
            },
            // Используется в b-edit-group-2 для вывода ошибок при сохранении ТГО на java
            this.ctx.errorsPrettyMessage || '',
            {
                elem: 'control-content',
                content: {
                    block: 'input',
                    mix: [{
                        block: 'b-edit-group-header',
                        elem: 'name-input'
                    }].concat(this.ctx.inputMix),
                    value: this.ctx.groupName,
                    content: {
                        block: 'input',
                        elem: 'control'
                    }
                }
            }
        ];
    }),

    elem('info').content()(function() {
        return [
            {
                elem: 'inner-row',
                content: '&nbsp;'
            },
            {
                elem: 'info-content',
                content: this.ctx.text
            }
        ];
    }),

    content()(function() {
        return {
            block: 'b-edit-group',
            elem: 'row',
            content: [
                {
                    block: 'b-edit-group-header',
                    elem: 'label',
                    mix: {
                        block: 'b-edit-group',
                        elem: 'label'
                    }
                },
                {
                    block: 'b-edit-group-header',
                    elem: 'control',
                    mix: {
                        block: 'b-edit-group',
                        elem: 'control'
                    },
                    groupNumber: this.ctx.groupNumber,
                    groupName: this.ctx.group_name
                },
                {
                    block: 'b-edit-group-header',
                    elem: 'info',
                    mix: {
                        block: 'b-edit-group',
                        elem: 'info'
                    },
                    elemMods: { 'has-second-row': this.mods.type == 'mobile-content' ? 'yes' : '' },
                    floater: 'yes',
                    text: this.ctx.text
                }
            ]
        };
    })
);
