BEM.DOM.decl('b-edit-group-header', {
    onSetMod: {
        js: function() {
            this.input = this.findBlockOn('name-input', 'input');

            if (this.params.modelParams) {
                this.setGroupModelParams(this.params.modelParams);
            }
        }
    },

    getGroupModelParams: function() {
        return this.modelParams;
    },

    setGroupModelParams: function(modelParams) {
        //если был ранее установлен adgroupId - отписываемся от предыдущих событий
        if (this.modelParams) this._bindEvents({ isBind: false });

        this.modelParams = modelParams;
        this.model = BEM.MODEL.getOne(modelParams);

        var currNum = this.model.get('isCopyGroup') ?
                this.model.getBanners().length :
                    this.model.getBanners().filter(function(bannerModel) {
                        return !bannerModel.get('isNewBanner');
                    }).length,
            totalNum = this.model.get('banners_quantity'),
            groupNumber = this.model.get('adgroup_id'),
            text = u['b-edit-group-header'].getInfoContentText(currNum, totalNum, this.getMod('type'));

        this.input.val(this.model.get('group_name'));
        this.elem('info-content').text(text);

        if (+groupNumber && !this.model.get('isCopyGroup')) {
            this.setMod('show-inner-row', 'yes');
            this.elem('group-number').text('№ ' + groupNumber);
        } else {
            this.delMod('show-inner-row');
        }

        this._bindEvents({ isBind: true });
    },

    /**
     *
     * @param {Object} options
     * @param {Boolean} options.isBind
     * @returns {BEM}
     */
    _bindEvents: function(options) {
        var action = options.isBind ? 'on' : 'un';

        this.input[action]('change', function() {
            this.model.set('group_name', this.input.val());
        }, this);

        this.model[action]('group_name', 'change', function() {
            if (this.input.hasMod('focused')) return;

            this.input.val(this.model.get('group_name'));
        }, this);

        return this;
    }
});
