(function() {
    /**
     * Возвращает текст подсказки для случая, когда общее количество и количество выбранных объявлений равно
     * @param {Number} num
     * @paran {String} type
     * @returns {String}
     */
    function getTotalItemsText(num, type) {
        switch (type) {
            case 'performance':
            case 'mcbanner':
                return u.pluralize([iget2('b-edit-group-header', 'banner-113', 'баннер'), iget2('b-edit-group-header', 'bannera', 'баннера'),iget2('b-edit-group-header', 'bannerov', 'баннеров')], num);

            default:
                return u.pluralize([iget2('b-edit-group-header', 'obyavlenie-111', 'объявление'), iget2('b-edit-group-header', 'obyavleniya', 'объявления'),iget2('b-edit-group-header', 'obyavleniy', 'объявлений')], num);
        }
    }

    /**
     * Возвращает текст подсказки для случая, когда общее количество и количество выбранных объявлений не равно
     * @param {Number} currNum
     * @param {Number} totalNum
     * @param {String} type - тип кампании
     * @returns {String}
     */
    function getPartialItemsText(currNum, totalNum, type) {
        switch (type) {
            case 'performance':
            case 'mcbanner':
                return iget2('b-edit-group-header', '1-of-5-banners', '{foo} из {bar} баннера', {
                    foo: currNum,
                    bar: totalNum,
                    count: totalNum,
                    some: '{foo} из {bar} баннеров',
                    many: '{foo} из {bar} баннеров',
                    context: '1 из 5 баннеров'
                });
            default:
                return iget2('b-edit-group-header', '1-of-5-ads', '{foo} из {bar} объявления', {
                    foo: currNum,
                    bar: totalNum,
                    count: totalNum,
                    some: '{foo} из {bar} объявлений',
                    many: '{foo} из {bar} объявлений',
                    context: '1 из 5 объявлений'
                });
        }
    }

    u.register({
        'b-edit-group-header': {
            /**
             * Возвращает текст подсказки о количестве редактирумеых баннеров
             * @param {Number} currNum - выбранное количество баннеров
             * @param {Number} totalNum - общее количество баннеров
             * @param {String} headerType - тип кампании
             * @returns {String}
             */
            getInfoContentText: function(currNum, totalNum, headerType) {
                return (currNum == totalNum) ?
                    getTotalItemsText(currNum, headerType) :
                    getPartialItemsText(currNum, totalNum, headerType);
            }
        }
    });
})();
