/**
 * Блок редактирования ссылки на мобильный контент
 * @pram modelId
 * @pram value
 */
block('b-edit-group-mobile-content-href')(

    def()(function() {
        var href = this.ctx.value,
            maxLength = u.consts('MAX_URL_LENGTH'),
            url = href ? href : '';

        this._modelData = {
            url: url,
            maxLength: maxLength,
            hrefLengthLeft: maxLength - url.length,
            lengthExceeded: url.length > maxLength
        };

        return applyNext({
            'ctx.mix': (this.ctx.mix || []).concat({
                block: 'b-edit-group-mobile-content-href',
                elem: 'model-field',
                js: {
                    name: 'isUpdating',
                    type: 'mod',
                    block: 'b-edit-group-mobile-content-href',
                    modName: 'updating'
                }
            })
        });
    }),

    js().match(function() {
        return !this.mods || this.mods['read-only'] !== 'yes';
    })(function() {
        return {
            modelParams: {
                name: 'b-edit-group-mobile-content-href',
                id: this.ctx.modelId,
                data: this._modelData
            },
            value: this._storeContentHref
        };
    }),

    content()(function() {
        return [
            {
                block: 'input',
                value: this._modelData.url,
                mix: [
                    {
                        block: 'b-edit-group-mobile-content-href',
                        elem: 'url'
                    },
                    {
                        block: 'b-edit-group-mobile-content-href',
                        elem: 'model-field',
                        js: [
                            {
                                name: 'url',
                                type: 'input'
                            },
                            {
                                name: 'isUpdating',
                                type: 'mod',
                                block: 'input',
                                modName: 'disabled'
                            }
                        ]
                    }
                ],
                content: [{
                    elem: 'control',
                    attrs: {
                        autocomplete: 'off'
                    }
                }]
            },
            {
                elem: 'popup',
                apps: this.ctx.apps
            },
            {
                elem: 'numerator',
                elemMods: { exceeded: this._modelData.lengthExceeded ? 'yes' : '' },
                tag: 'span',
                mix: {
                    block: 'b-edit-group-mobile-content-href',
                    elem: 'model-field',
                    js: [
                        {
                            name: 'lengthExceeded',
                            type: 'mod',
                            block: 'b-edit-group-mobile-content-href',
                            elem: 'numerator',
                            modName: 'exceeded'
                        },
                        {
                            name: 'hrefLengthLeft',
                            type: 'inline'
                        }
                    ]
                },
                content: this._modelData.hrefLengthLeft || this._modelData.maxLength
            },
            {
                block: 'spin2',
                mods: { size: 'xs' },
                mix: [
                    {
                        block: 'b-edit-group-mobile-content-href',
                        elem: 'spin'
                    },
                    {
                        block: 'b-edit-group-mobile-content-href',
                        elem: 'model-field',
                        js: {
                            name: 'isUpdating',
                            type: 'mod',
                            block: 'spin2',
                            modName: 'progress'
                        }
                    }
                ]
            }
        ];
    }),

    mod('read-only', 'yes').content()(function() {
        return {
            elem: 'read-only-href',
            content: this.ctx.value || iget2('b-edit-group-mobile-content-href', 'ssylka-ne-zadana', 'ссылка не задана')
        };
    })
);
