/**
 * Блок Ссылка на приложение в магазине (РМП)
 * @fires start-editing – срабатывает в момент изменения урла после установки фокуса на контрол
 * @fires end-editing – срабатывает в момент окончания получения данных из стора, либо после ухода фокуса без изменения урла
 */
BEM.DOM.decl({ block: 'b-edit-group-mobile-content-href', baseBlock: 'i-glue' } , {

    onSetMod: {
        js: function() {
            if (this.getMod('read-only') === 'yes') return;

            this.__base.apply(this, arguments);

            this.model.init();

            this._urlInput = this.findBlockOn('url', 'input');
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this.bindToDoc('pointerclick', this._onWinClickHandler);
            this.bindToDomElem(this._urlInput.domElem, 'keydown',this._onInputKeydown);

            if (this.elem('app').length > 0) {
                this._subscriptionManager.wrap(this._urlInput)
                    .on('focus', this._onInputFocus, this)
                    .on('blur', this._onInputBlur, this);

                this._subscriptionManager.wrap(BEM.blocks['link'])
                    .on(this.elem('apps-list'), 'click', this._onSelectApp, this)
                    .on(this.elem('apps-list'), 'keydown', function(e) {
                        if (BEM.blocks.keycodes.is(e.keyCode, 'TAB')) {
                            this._onTabPress(e);
                        }
                        if (BEM.blocks.keycodes.is(e.keyCode, 'ESC')) {
                            this._notOpenPopup = true;
                            this._urlInput.setMod('focused', 'yes');
                            this._closePopup();
                        }
                    }, this);
            }
        },

        updating: function(modName, modVal) {
            if (!modVal) { // получение данных из store закончилось
                this.trigger('end-editing');
                this.model.fix();
            }
        }
    },

    /**
     * Открывает попап со списком приложений
     * @private
     */
    _openPopup: function() {
        this.blockInside('popup2')
            .setAnchor(this.elem('url'))
            .setMod('visible', 'yes');
    },

    /**
     * Закрывает попап со списком приложений
     * @private
     */
    _closePopup: function() {
        this.blockInside('popup2').delMod('visible');
    },

    /**
     * Проверяет находиться ли target внутри этого блока
     * @param {DOM} target
     * @return {number|jQuery|*|Boolean}
     * @private
     */
    _isTargetInBlock: function(target) {
        return $(target).parents(this.buildSelector('apps-list')).length || this.containsDomElem($(target));
    },

    /**
     * Обработчик клика на все странице
     * @param {Event} e
     * @private
     */
    _onWinClickHandler: function(e) {

        if (this._isDestructing) {
            return;
        }

        if (!this._isTargetInBlock(e.target)) {
            this._onBlur(e);
        }
    },

    /**
     * Обработчик начала редактирования урла
     * Нужен, чтобы кнопка "далее" становилась неактивной не после фокуса, а после первого изменения
     * @param {jQuery.Event} e
     * @param {Object} [data] - данные события
     * @private
     */
    _onStartEditUrl: function(e, data) {
        e.block.un('change', this._onStartEditUrl, this);

        data && data.selected || this.trigger('start-editing');
    },

    /**
     * Обработчик выбора приложения из списка
     * @param {Event} e
     * @private
     */
    _onSelectApp: function(e) {
        var params = e.block.params;

        this.model.syncMobileContent(params);

        // иначе i-glue перезатирает
        this.afterCurrentEvent(function() {
            this._urlInput.val(params.storeHref, { selected: true });
        }, this);

        BEM.blocks['b-metrika2'].reachGoal('RMP_F3_APP_SELECTED_FROM_ZERO_SUGGEST');
        this._closePopup();
        this.trigger('end-editing');
        this.model.fix();
    },

    _onInputKeydown: function(e) {
        if (BEM.blocks.keycodes.TAB === e.keyCode) {
            this._onTabPress(e);
        }
        if (BEM.blocks.keycodes.ESC === e.keyCode) {
            this._closePopup();
        }
    },

    /**
     * Обраюотчик фокуса в инпуте
     * @param {Event} e
     * @private
     */
    _onInputFocus: function(e) {
        this._urlInput.on('change', this._onStartEditUrl, this);

        if (!this._notOpenPopup) {
            this._openPopup();
        }

        this._notOpenPopup = false;
    },

    /**
     * Обраюотчик blur в инпуте
     * @param {Event} e
     * @private
     */
    _onInputBlur: function(e) {
        if (!this._isTargetInBlock(document.activeElement)) {
            this._onBlur();
        }
    },

    /**
     * Обраюотчик blur в связке инпут+попап
     * @param {Event} e
     * @private
     */
    _onBlur: function(e) {
        this._urlInput.un('change', this._onStartEditUrl, this);

        this.model.get('url') && this.model.fields['url'].isChanged() || this.trigger('end-editing');
        this.model.syncHref();
        this._closePopup();
    },

    /**
     * Обработчик нажатия tab в блоке и попапе
     * @param {Event} e
     * @private
     */
    _onTabPress: function(e) {
        if (this._urlInput.hasMod('focused', 'yes')) {
            if (this.blockInside('popup2').hasMod('visible', 'yes')) {
                this.elem('app').eq(0).focus();
                e.preventDefault();
            }
        } else if (
            this.elem('app').eq(this.elem('app').length - 1).isFocused() ||
                (e.shiftKey && this.elem('app').eq(0).isFocused())
        ) {
            this._notOpenPopup = true;
            this._urlInput.setMod('focused', 'yes');
            this._closePopup();
            e.preventDefault();
        }

    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        this.unbindFromDoc('pointerclick');
        this.unbindFromDomElem(this._urlInput.domElem,'keydown');
        this.__base.apply(this, arguments);
    }

});
