BEM.MODEL.decl({ model: 'b-edit-group-mobile-content-href', baseModel: 'vm-sync-dm2' }, {

    _dmDecl: {
        type: 'object',
        internal: true,
        calculate: function() {
            return {
                group: {
                    name: 'dm-mobile-content-group',
                    id: this.id
                }
            };
        }
    },

    // Часть ссылки без протокола
    url: {
        type: 'string',
        preprocess: function(val) {

            if (u.validation.isUrl(val)) {
                var hrefParams = u.parseUrl(val);

                hrefParams.protocol ||
                    (val = u.formatUrl(u._.extend(hrefParams, { protocol: 'https://' })));
            }

            return val;
        }
    },

    // Количество доступных символов
    hrefLengthLeft: {
        type: 'number',
        precision: 0,
        calculate: function() {
            return u.consts('MAX_URL_LENGTH') - (this.get('url') || '').length;
        },
        dependsFrom: ['url']
    },

    // Состояние переполнения доступных символов
    lengthExceeded: {
        type: 'boolean',
        calculate: function() {
            return this.get('hrefLengthLeft') < 0;
        },
        dependsFrom: ['hrefLengthLeft']
    },

    existingApp: {
        type: 'boolean',
        default: true
    },

    // Происходит получение данных из store
    isUpdating: 'boolean'

}, {

    init: function() {
        this.__base.apply(this, arguments);

        this.getDM().group.on('mobile_content_updating', 'change', function() {
            this.set('isUpdating', this.getDM().group.get('mobile_content_updating'));
        }, this);

    },

    /**
     * Синхронизирует href в DM
     */
    syncHref: function() {
        this.getDM().group.set('mobile_content_exist', false);
        this.getDM().group.set('store_content_href', this.get('url'));
    },

    syncMobileContent: function(data) {
        var trackerUrlHref = '';

        this.getDM().group.set('mobile_content_exist', true);
        this.getDM().group.set('store_content_href', data.storeHref);
        this.getDM().group.set('mobile_content', data.mobileContent);

        if ((data.trackers || []).length) {
            trackerUrlHref = data.trackers[0].url;
        }

        this.getDM().group.getBanners().forEach(function(bannerModel) {
            bannerModel.set('href', trackerUrlHref, { action: 'change-mobile-app' });
        });

    }
});
