block('b-edit-group').elem('cpm-group-type-title').content()(function() {
    var ctx = this.ctx,
        selected = ctx.selected || 'cpm_banner',
        dictionary = {},
        needSelect = ctx.isNewGroup || ctx.isCopyGroup;

    dictionary.cpm_banner = dictionary.cpm_deals = dictionary.cpm_yndx_frontpage = iget2('b-edit-group', 'group-type-cpm-banner', 'баннеры');
    dictionary.cpm_video = dictionary.cpm_video_deals = iget2('b-edit-group', 'group-type-cpm-video', 'видео');

    if (!needSelect) {
        dictionary.cpm_video = [
            dictionary.cpm_video,
            {
                block: 'b-beta',
                mods: { type: 'symbol' },
                mix: {
                    block: 'b-edit-group',
                    elem: 'cpm-group-type-title-beta'
                }
            }
        ];
    }

    return u.spacer([
        iget2('b-edit-group', 'cpm-adgroup-type', 'Тип объявлений'),
        [
            needSelect ?
                {
                    block: 'select2',
                    mods: {
                        type: 'radio',
                        theme: 'transparent',
                        size: 'xl',
                        text: 'vary',
                        disabled: ctx.isCopyGroup ? 'yes' : undefined
                    },
                    mix: {
                        block: 'b-edit-group',
                        elem: 'cpm-group-type-selector'
                    },
                    val: selected,
                    items: [
                        {
                            val: 'cpm_banner',
                            text: dictionary['cpm_banner']
                        },
                        {
                            val: 'cpm_video',
                            elemMods: { with: 'beta' },
                            text: dictionary['cpm_video']
                        }
                    ]
                } :
                dictionary[selected],
            {
                block: 'b-help-link',
                mix: {
                    block: 'b-edit-group',
                    elem: 'help-link'

                },
                mods: { type: 'modal' },
                stretched: true,
                icon: 'question',
                url: u.getHelpUrl('cpm-campaign-ad-group-type')
            }
        ]
    ], ':&nbsp;');
});
