block('b-edit-group').elem('data-source').def()(function() {
    var promoCodeDomains = this.promoCodeDomains;

    return {
        mixes: {
            row: [
                {
                    block: 'b-edit-group',
                    elem: 'data-source'
                },
                {
                    block: 'b-dynamic-group-domain',
                    js: {
                        modelParams: {
                            name: 'b-dynamic-group-domain',
                            id: this.group.modelId
                        },
                        modelData: {
                            lengthLimit: u.consts('MAX_URL_LENGTH')
                        }
                    }
                }
            ]
        },
        label: {
            block: 'b-error-label',
            js: {
                path: this.errorPath('main_domain')
            },
            content: {
                block: 'b-error-label',
                js: {
                    path: this.errorPath('feed_id')
                },
                content: [
                    iget2('b-edit-group', 'istochnik-dannyh', 'Источник данных'),
                    {
                        block: 'b-mark-required'
                    }
                ]
            }
        },
        control: [
            {
                block: 'b-error-message',
                js: {
                    path: this.errorPath('main_domain')
                }
            },
            {
                block: 'b-error-message',
                js: {
                    path: this.errorPath('feed_id')
                }
            },
            {
                block: 'b-edit-group',
                elem: 'control-wrap',
                content: [
                    {
                        block: 'radio-button',
                        mods: { disabled: 'yes' },
                        mix: [
                            {
                                block: 'i-glue',
                                elem: 'model-field',
                                js: {
                                    name: 'data_source',
                                    type: 'radio-button'
                                }
                            },
                            {
                                block: 'b-edit-group',
                                elem: 'switch-source'
                            }
                        ],
                        value: this.group.data_source,
                        content: [
                            {
                                elem: 'radio',
                                controlAttrs: {
                                    value: 'domain'
                                },
                                content: iget2('b-edit-group', 'sayt', 'Сайт')
                            },
                            {
                                elem: 'radio',
                                controlAttrs: {
                                    value: 'feed'
                                },
                                content: iget2('b-edit-group', 'fid', 'Фид')
                            }
                        ]
                    },
                    {
                        block: 'b-dynamic-group-domain',
                        mix: [
                            {
                                block: 'b-edit-group',
                                elem: 'elem',
                                elemMods: { source: 'domain' }
                            },
                            {
                                block: 'b-edit-group',
                                elem: 'source-control'
                            }
                        ],
                        elem: 'controls',
                        group: this.group
                    },
                    {
                        block: 'b-group-feed',
                        mix: [
                            {
                                block: 'b-edit-group',
                                elem: 'elem',
                                elemMods: { source: 'feed' }
                            },
                            {
                                block: 'b-edit-group',
                                elem: 'source-control'
                            },
                            {
                                block: 'b-edit-group',
                                elem: 'feed'
                            }
                        ],
                        groupId: this.group.adgroup_id,
                        selectedFeedId: this.group.feed_id,
                        feeds: this.feeds || []
                    }
                ]
            },
            {
                block: 'b-dynamic-group-domain',
                elem: 'hint',
                mix: [
                    {
                        block: 'b-edit-group',
                        elem: 'elem',
                        elemMods: { source: 'domain' }
                    },
                    {
                        block: 'b-edit-group',
                        elem: 'hint'
                    }
                ]
            },
            promoCodeDomains && promoCodeDomains.length > 0 && {
                block: 'b-dynamic-group-domain',
                elem: 'promo-code-warning',
                mix: [
                    {
                        block: 'b-edit-group',
                        elem: 'elem',
                        elemMods: { source: 'domain' }
                    },
                    {
                        block: 'b-edit-group',
                        elem: 'promo-code-warning',
                        elemMods: { hidden: 'yes' }
                    }
                ]
            },
            (!this.feeds || !this.feeds.length) && {
                block: 'b-group-feed',
                elem: 'hint',
                mix: [
                    {
                        block: 'b-edit-group',
                        elem: 'elem',
                        elemMods: { source: 'feed' }
                    },
                    {
                        block: 'b-edit-group',
                        elem: 'hint'
                    }
                ]
            }
        ],
        info: {
            block: 'b-dynamic-group-domain',
            elem: 'domain-message',
            mix: [
                {
                    block: 'b-edit-group',
                    elem: 'elem',
                    elemMods: { source: 'domain' }
                }
            ]
        }
    };
});
