block('b-edit-group').elem('dynamic-conditions').def()(function() {

    var conditions = this.ctx.conditions,
        isDefaultCondition = conditions.length == 1 && conditions[0].condition.every(function(goal) {
            return goal.type == 'any';
        }),
        //если нет group.main_domain то в group_dynamic_conditions лежат ошибки по фильтрам для фида
        errors = this.group.main_domain && this.errors.group_dynamic_conditions;

    return {
        mixes: {
            row: {
                block: 'b-edit-group',
                elem: 'dynamic-conditions'
            },
            label: {
                block: 'b-error-label',
                js: {
                    path: this.ctx.errorPath
                }
            }
        },
        label: [
            iget2('b-edit-group', 'usloviya-nacelivaniya', 'Условия нацеливания'),
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                mix: [{
                    block: 'b-edit-banner2',
                    elem: 'help-icon'
                }],
                stretched: true,
                url: u.getHelpUrl('dynamic-text-ads-select-targets')
            }
        ],
        control: applyCtx([
            {
                block: 'b-error-message',
                js: {
                    path: this.ctx.errorPath
                },
                mix: {
                    block: 'b-edit-group',
                    elem: 'dynamic-conditions-error-message'
                }
            },
            {
                block: 'b-dynamic-conditions2',
                mods: {
                    type: isDefaultCondition ? 'any' : 'detailed'
                },
                type: isDefaultCondition ? 'any' : 'detailed',
                groupId: this.group.modelId,
                conditions: this.ctx.conditions,
                currency: this.ctx.currCode,
                strategy: this.ctx.strategy,
                errors: errors
            }
        ])
    };
});
