block('b-edit-group').elem('limit-rate').def()(function() {
    var ctx = this.ctx,
        doShowLimitRateOutside = ctx.doShowLimitRateOutside;

    return {
        mixes: {
            row: [
                {
                    block: 'b-edit-group',
                    elem: 'row',
                    elemMods: {
                        theme: doShowLimitRateOutside ? '' : 'grey',
                        type: 'limit-rate'
                    }
                }
            ],
            label: [{
                block: 'b-edit-group',
                elem: 'label'
            }],
            info: [{
                block: 'b-edit-group',
                elem: 'info'
            }],
            control: [{
                block: 'b-edit-group',
                elem: 'control'
            }]
        },
        label: {
            block: 'b-model-form-error',
            mix: {
                block: 'b-model-form-error',
                elem: 'label'
            },
            modelParams: ctx.modelParams,
            field: 'general_limit_price',
            errors: this.errors.general_limit_price,
            validateOnChange: true,
            content: ctx.labelContent || [
                ctx.labelText || iget2('b-edit-group', 'maksimalnaya-stavka-dlya', 'Максимальная ставка для новых и измененных условий показа'),
                ctx.isLimitRateRequired && {
                    block: 'b-mark-required',
                    mix: [{
                        block: 'b-model-form-error',
                        elem: 'required'
                    }]
                },
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    stretched: true,
                    mix: [{
                        block: 'b-edit-group',
                        elem: 'help-icon'
                    }],
                    url: u.getHelpUrl(ctx.helpLinkId || 'maximum-bid')
                }
            ]
        },
        control: [
            {
                block: 'b-edit-group',
                elem: 'wrap',
                content: [
                    {
                        block: 'b-edit-phrase-price',
                        mods: {
                            'control-type': 'general-limit',
                            'real-time': 'yes',
                            multiedit: 'yes'
                        },
                        mix: {
                            block: 'b-edit-group',
                            elem: 'general-limit-price'
                        },
                        price: ctx.price,
                        campDMParams: ctx.campDMParams,
                        popupDirections: ['bottom', 'top'],
                        currency: ctx.currency
                    },
                    {
                        block: 'b-edit-group',
                        elem: 'general-limit-price-description',
                        content: iget2('b-edit-group', 'currency-valyuta-za-target', '{currency} за {target}', {
                            currency: u.currencies.getName(ctx.currency),
                            target: ctx.targetText || iget2('b-edit-group', 'klik', 'клик'),
                            context: 'currency - валюта; target - клик/показы'
                        })
                    },
                    typeof this.errorPath === 'function' && {
                        block: 'b-error-message',
                        mix: {
                            block: 'b-edit-group',
                            elem: 'general-limit-price-error'
                        },
                        js: {
                            path: this.errorPath('general_limit_price')
                        }
                    }
                ]
            }
        ]
    };
});
