block('b-edit-group').elem('regions').elemMod('type', 'error2').def()(function() {
    var group = this.group,
        campaign = this.campaign,
        extendedGeo = campaign.extended_geo,
        modelId = group.modelId,
        modelParams = {
            name: 'm-geo-regions',
            id: modelId,
            parentName: this.groupModelName,
            parentId: modelId
        },
        errorPath = this.errorPath('geo'),
        regionsTreeInfo = u.getRegionsTreeInfo(
            u.getRegionsTree(this.data.lang + (this.data.translocal_tree_type === 'ru' ? '_for_ru' : '')),
            extendedGeo,
            {
                cid: campaign.cid,
                mediaType: campaign.mediaType,
                groupNames: campaign.pid_to_group_name || {}
            }),
        bids = u.getBidsFromExtendedData(extendedGeo);

    return {
        mixes: {
            control: [{
                block: 'b-edit-group',
                elem: 'control',
                elemMods: {
                    regions: 'yes'
                }
            }],
            label: [{
                block: 'b-error-label',
                js: {
                    path: errorPath
                }
            }],
            info: [{
                block: 'b-edit-group',
                elem: 'info',
                elemMods: {
                    regions: 'yes'
                }
            }]
        },
        label: [
            iget2('b-edit-group', 'regiony-pokaza', 'Регионы показа'),
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                mix: [{
                    block: 'b-edit-banner2',
                    elem: 'help-icon'
                }],
                stretched: true,
                url: u.getHelpUrl('geotargeting'),
                width: 1100,
                title: iget2('b-edit-group', 'kakie-regiony-vybrat', 'Какие регионы выбрать?')
            }
        ],
        info: {
            block: 'b-regions-selector',
            isEditable: true,
            modelParams: modelParams,
            js: {
                id: 'b-regions-selector-' + modelId
            },
            elem: 'geo-warning',
            elemMods: {
                active: group.geo === '0' ? 'yes' : ''
            }
        },
        control: applyCtx([
            {
                block: 'b-error-message',
                js: {
                    path: errorPath
                }
            },
            {
                block: 'b-regions-selector',
                isEditable: true,
                modelParams: modelParams,
                js: { id: 'b-regions-selector-' + modelId },
                hintMixes: [
                    { block: 'b-edit-group', elem: 'regions-value' }
                ],
                regions: regionsTreeInfo.regions,
                geo: group.geo,
                geoText: group.geo_names || u.getGeoNames(group.geo),
                productType: this.data.mediaType,
                // TODO DIRECT-67228: b-regions-tree:
                // TODO оптимизировать обход дерева и научится строить дерево по id-шникам регионов в любом порядке
                regionsTreeInfoParams: {
                    lang: this.data.lang + (this.data.translocal_tree_type === 'ru' ? '_for_ru' : ''),
                    cid: campaign.cid,
                    mediaType: campaign.mediaType,
                    groupNames: campaign.pid_to_group_name || {}
                },
                modelId: modelId,
                hasBidsCorrections: true,
                bids: bids,
                isBidsCorrectionsModeOn: campaign.geo_multipliers_enabled,
                disableEditBids: true,
                disableEditBidsHint: iget2('b-edit-group', 'mozhno-dobavit-tolko-dlya', 'Можно добавить только для кампании')
            }
        ])
    };

});
