block('b-edit-group').elem('regions').def()(function() {
    var group = this.group,
        campaign = this.campaign,
        extendedGeo = campaign.extended_geo,
        adgroupId = group.modelId,
        parentModelName = this.ctx.parentModelName,
        regionModelParams = {
            name: 'm-geo-regions',
            id: adgroupId,
            parentName: parentModelName || 'm-group',
            parentId: adgroupId
        },
        regionsTreeInfo = u.getRegionsTreeInfo(
            u.getRegionsTree(this.data.lang + (this.data.translocal_tree_type === 'ru' ? '_for_ru' : '')),
            extendedGeo,
            {
                cid: campaign.cid,
                mediaType: campaign.mediaType,
                groupNames: campaign.pid_to_group_name || {}
            }),
        bids = u.getBidsFromExtendedData(extendedGeo);

    return {
        mixes: {
            control: [{
                block: 'b-edit-group',
                elem: 'control',
                elemMods: {
                    regions: 'yes'
                }
            }],
            info: [{
                block: 'b-edit-group',
                elem: 'info',
                elemMods: {
                    regions: 'yes'
                }
            }]
        },
        label: applyCtx({
            block: 'b-model-form-error',
            mix: [{
                block: 'b-model-form-error',
                elem: 'label'
            }],
            modelParams: regionModelParams,
            field: 'geo',
            errors: this.errors.geo,
            content: [
                iget2('b-edit-group', 'regiony-pokaza', 'Регионы показа'),
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    mix: [{
                        block: 'b-edit-banner2',
                        elem: 'help-icon'
                    }],
                    stretched: true,
                    url: u.getHelpUrl('geotargeting'),
                    width: 1100,
                    title: iget2('b-edit-group', 'kakie-regiony-vybrat', 'Какие регионы выбрать?')
                }
            ]
        }),
        info: {
            block: 'b-regions-selector',
            isEditable: true,
            modelParams: regionModelParams,
            js: {
                id: 'b-regions-selector-' + adgroupId
            },
            elem: 'geo-warning',
            elemMods: {
                active: group.geo === '0' ? 'yes' : ''
            }
        },
        control: applyCtx([
            {
                block: 'b-model-form-error',
                mix: [{
                    block: 'b-model-form-error',
                    elem: 'control'
                }],
                modelParams: regionModelParams,
                field: 'isSpecified',
                errors: this.errors.geo
            },
            {
                block: 'b-regions-selector',
                isEditable: true,
                modelParams: regionModelParams,
                js: {
                    id: 'b-regions-selector-' + adgroupId
                },
                hintMixes: [
                    { block: 'b-edit-group', elem: 'regions-value' }
                ],
                regions: regionsTreeInfo.regions,
                geo: group.geo,
                geoText: group.geo_names || u.getGeoNames(group.geo),
                productType: this.data.mediaType,
                // TODO DIRECT-67228: b-regions-tree:
                // TODO оптимизировать обход дерева и научится строить дерево по id-шникам регионов в любом порядке
                regionsTreeInfoParams: {
                    lang: this.data.lang + (this.data.translocal_tree_type === 'ru' ? '_for_ru' : ''),
                    cid: campaign.cid,
                    mediaType: campaign.mediaType,
                    groupNames: campaign.pid_to_group_name || {}
                },
                modelId: adgroupId,
                hasBidsCorrections: true,
                bids: bids,
                isBidsCorrectionsModeOn: campaign.geo_multipliers_enabled,
                disableEditBids: true,
                disableEditBidsHint: iget2('b-edit-group', 'mozhno-dobavit-tolko-dlya', 'Можно добавить только для кампании'),
                geoSuggestForQuickSelect: this.data.geo_suggest_for_quick_select
            }
        ])
    };

});
