block('b-edit-group').elem('relevance-match').def()(function() {
    var modelName = this.ctx.modelName || 'm-group',
        relevanceMatch = u._.isArray(this.group['relevance_match']) && this.group['relevance_match'][0],
        isRelevanceMatchOn = !!relevanceMatch,
        isNewMobileContentGroup = (this.group.adgroup_type === 'mobile_content' && this.group.isNewGroup),
        status;

    return {

        label: applyCtx({
            block: 'b-model-form-error',
            mix: [
                {
                    block: 'b-model-form-error',
                    elem: 'label'
                }
            ],
            modelName: modelName,
            modelId: this.group.modelId,
            field: 'has_relevance_match',
            errors: this.errors['relevance_match'],
            content: [
                iget2('b-edit-group', 'ispolzovat-avtotargeting', 'Использовать автотаргетинг'),
                {
                    block: 'b-help-link',
                    mods: { type: 'modal' },
                    stretched: true,
                    mix: [
                        { block: 'b-edit-group', elem: 'help-icon' },
                        { block: 'b-edit-group', elem: 'relevance-match-help' }
                    ],
                    url: u.getHelpUrl('autotargeting'),
                    title: iget2('b-edit-group', 'chto-takoe-avtotargeting', 'Что такое автотаргетинг?')
                }
            ]
        }),
        control: this.ctx.readOnly ?
            (isRelevanceMatchOn || isNewMobileContentGroup) ?
                iget2('b-edit-group', 'da', 'Да') :
                iget2('b-edit-group', 'net', 'Нет') :
            applyCtx([
                {
                    block: 'b-model-form-error',
                    mix: [{ block: 'b-model-form-error', elem: 'control' }],
                    modelName: modelName,
                    modelId: this.group.modelId,
                    field: 'has_relevance_match',
                    errors: this.errors['has_relevance_match']
                },
                {
                    block: 'tumbler',
                    name: 'relevance_match',
                    mods: {
                        size: 's',
                        checked: (isRelevanceMatchOn || isNewMobileContentGroup) ? 'yes' : ''
                    },
                    mix: { block: 'b-edit-group', elem: 'relevance-match-tumbler' },
                    leftText: iget2('b-edit-group', 'da', 'Да'),
                    rightText: iget2('b-edit-group', 'net', 'Нет')
                },
                isRelevanceMatchOn && {
                    block: 'b-edit-group',
                    elem: 'relevance-match-status',
                    content: status
                }
            ])
    };
});
