block('b-edit-group').elem('rename-group').def()(function() {
    var group = this.group,
        modelParams = {
            id: group.modelId,
            name: this.ctx.modelName || this.groupModelName
        },
        headerType = this.ctx.headerType;

    return {
        mixes: {
            row: [
                {
                    block: 'b-edit-group',
                    elem: 'rename-group',
                    elemMods: { single: group.isSingleGroup ? 'yes' : '' }
                },
                {
                    block: 'b-edit-group-header',
                    mods: {
                        type: headerType,
                        'show-inner-row': (group.adgroup_id && !group.isCopyGroup) ? 'yes' : undefined
                    },
                    js: {
                        modelParams: modelParams,
                        banners_quantity: group.banners_quantity
                    }
                }
            ]
        },

        label: {
            block: 'b-model-form-error',
            mix: [{
                block: 'b-model-form-error',
                elem: 'label'
            }],
            modelParams: modelParams,
            field: 'group_name',
            errors: this.errors && this.errors.group_name,
            content: {
                block: 'b-edit-group-header',
                attrs: {
                    id: 'Group-' + this.group.modelId
                },
                elem: 'label'
            }
        },
        control: {
            block: 'b-edit-group-header',
            elem: 'control',
            group_name: group.group_name,
            groupNumber: group.adgroup_id
        },
        info: [
            //не создание группы и не копирование одной группы
            !this.isNewGroup && !group.isCopyGroup && {
                block: 'b-edit-group-header',

                elem: 'info',
                text: (function() {
                    var currNum = group.isCopyGroup ?
                        group.banners.length :
                        group.banners.filter(function(banner) {
                            //при копировании нескольких групп нам не надо фильтровать баннеры с нулевыми id
                            return !banner.isNewBanner;
                        }).length,
                        totalNum = group.banners_quantity;

                    return u['b-edit-group-header'].getInfoContentText(currNum, totalNum, headerType);
                })()
            },
            //только для создания новой группы
            group.isSingleGroup && !group.adgroup_id && {
                block: 'b-edit-group',
                elem: 'help-text',
                content: this.ctx.helpText || iget2(
                    'b-edit-group',
                    'v-gruppe-vy-mozhete',
                    'В группе вы можете создать одно или несколько объявлений с общим набором ключевых фраз и едиными условиями показа.'
                )
            }

        ]
    };
});
