block('b-edit-group').elem('retargeting').def()(function() {
    var allRetargetingConditions = u.retargeting
            .filterConditionsByType(this.data.all_retargeting_conditions, 'metrika_goals'),
        retargetings = u.retargeting.filterGroupConditionsByType(
            this.group.retargetings || [],
            this.data.all_retargeting_conditions,
            'metrika_goals'
        );

    return {
        mixes: {
            row: {
                block: 'b-edit-group',
                elem: 'row',
                elemMods: {
                    type: 'retargeting'
                }
            }
        },
        label: [
            iget2('b-edit-group', 'usloviya-podbora-auditorii', 'Ретаргетинг и подбор аудитории'),
            {
                block: 'b-help-link',
                mods: {
                    type: 'modal'
                },
                mix: [{
                    block: 'b-edit-group',
                    elem: 'help-icon'
                }],
                stretched: true,
                url: u.getHelpUrl('retargeting-impressions'),
                title: iget2('b-edit-group', 'zachem-nuzhny-usloviya-podbora', 'Зачем нужны условия подбора аудитории?')
            }
        ],

        control: [
            typeof this.errorPath === 'function' && {
                block: 'b-error-message',
                mix: {
                    block: 'b-edit-group',
                    elem: 'general-limit-price-error'
                },
                js: {
                    path: this.errorPath('retargetings')
                }
            },
            applyCtx({
                block: 'b-group-retargeting2',
                mods: {
                    type: retargetings.length ? 'edit' : 'add'
                },
                mix: {
                    block: 'b-edit-group',
                    elem: 'outboard-control'
                },
                conditions: u.retargeting.transformServerData(allRetargetingConditions),
                selectedConditions: retargetings.map(function(condition) {

                    return {
                        ret_cond_id: condition.ret_cond_id,
                        ret_id: condition.ret_id,
                        condition_name: condition.condition_name,
                        is_accessible: allRetargetingConditions[condition.ret_cond_id].is_accessible
                    };
                })
            })
        ]
    };
});
