block('b-edit-group').elem('store-href').def()(function() {

    return {
        mixes: {
            row: [{
                block: 'b-edit-group',
                elem: 'store-href',
                elemMods: {
                    single: this.group.isSingleGroup ? 'yes' : '',
                    hidden: this.ctx.hidden
                }
            }]
        },
        label: applyCtx({
            block: 'b-model-form-error',
            mix: [{
                block: 'b-model-form-error',
                elem: 'label'
            }],
            modelName: this.ctx.modelName,
            modelId: this.group.modelId,
            field: 'store_content_href',
            errors: this.errors.group_group_name,
            content: [
                iget2('b-edit-group', 'ssylka-na-prilozhenie-v', 'Ссылка на приложение в магазине'),
                '&nbsp;',
                {
                    block: 'b-mark-required'
                },
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    mix: [{
                        block: 'b-edit-group',
                        elem: 'help-icon'
                    }],
                    stretched: true,
                    url: u.getHelpUrl('advertising-mobile-apps-url')
                }
            ]
        }),
        control: applyCtx([
            {
                block: 'b-model-form-error',
                mix: [{
                    block: 'b-model-form-error',
                    elem: 'control'
                }],
                modelName: this.ctx.modelName,
                modelId: this.group.modelId,
                field: 'store_content_href',
                errors: this.errors.group_store_content_href
            },
            {
                block: 'b-edit-group-mobile-content-href',
                mods: {
                    'read-only': this.ctx.readOnly ? 'yes' : 'no'
                },
                modelName: this.ctx.modelName,
                modelId: this.group.modelId,
                value: this.group.store_content_href,
                apps: this.data.app_mobile_content_list || []
            }
        ])
    };
});
