block('b-edit-group').elem('word-suggestions').elemMod('type', 'error2').def()(function() {
    var group = this.ctx.group,
        errorPath = this.ctx.errorPath,
        helpLinkId = this.ctx.helpLinkId;

    return {
        mixes: {
            row: [
                {
                    block: 'b-edit-group',
                    elem: 'row',
                    elemMods: {
                        type: 'word-suggestions'
                    }
                },
                {
                    block: 'b-group-add-phrases',
                    modelParams: {
                        name: this.ctx.modelName || 'm-group',
                        id: group.modelId
                    },
                    mix: [{
                        block: 'b-group-add-phrases',
                        elem: 'new'
                    }],
                    banner: group,
                    mods: {
                        suggestions: this.ctx.showSuggestions ? 'on' : 'off'
                    },
                    js: {
                        id: 'new_phrases_' + group.modelId,
                        adgroupId: group.modelId,
                        modelParams: {
                            name: this.ctx.modelName || 'm-group',
                            id: group.modelId
                        }
                    }
                }
            ],
            label: [
                {
                    block: 'b-edit-group',
                    elem: 'label'
                },
                {
                    block: 'b-error-label',
                    js: {
                        path: errorPath
                    }
                }
            ],
            info: [{
                block: 'b-edit-group',
                elem: 'info'
            }],
            control: [{
                block: 'b-edit-group',
                elem: 'control'
            }]
        },
        label: {
            block: 'b-group-add-phrases',
            elem: 'new-label',
            content: [
                iget2('b-edit-group', 'novye-klyuchevye-frazy', 'Новые ключевые фразы'),
                '&nbsp;',
                {
                    block: 'b-mark-required'
                },
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    stretched: true,
                    mix: [{
                        block: 'b-edit-group',
                        elem: 'help-icon'
                    }],
                    url: u.getHelpUrl(helpLinkId || 'add-keywords'),
                    title: iget2('b-edit-group', 'kak-pravilno-podbirat-klyuchevye', 'Как правильно подбирать ключевые фразы?')
                }
            ]
        },
        control: applyCtx([
            {
                block: 'b-error-message',
                mods: {
                    'has-cut': 'yes'
                },
                js: {
                    path: errorPath,
                    title: iget2('b-edit-group', 'oshibki-v-zapolnenii-polya', 'Ошибки в заполнении поля "Ключевые фразы"'),
                    cutText: iget2('b-edit-group', 'podrobnee', 'Подробнее')
                }
            },
            {
                block: 'button',
                mods: {
                    pseudo: 'yes'
                },
                mix: [{
                    block: 'b-group-add-phrases',
                    elem: 'suggestions-toggler'
                }],
                content: iget2('b-edit-group', 'pokazat-podskazki', 'Показать подсказки')
            },
            {
                block: 'b-outboard-controls',
                js: {
                    id: 'wordstat-control'
                },
                content: {
                    elem: 'switcher',
                    js: {
                        innerBlockParams: {
                            adgroupId: group.modelId,
                            modelName: this.ctx.modelName
                        }
                    },
                    switcher: {
                        block: 'button',
                        mods: {
                            theme: 'normal'
                        },
                        mix: [{
                            block: 'b-outboard-controls',
                            elem: 'switcher-button'
                        }],
                        content: iget2('b-edit-group', 'podobrat-slova', 'Подобрать слова')
                    }
                }
            },
            {
                block: 'b-group-add-phrases',
                elem: 'content-wrapper',
                modelParams: {
                    name: this.ctx.modelName || 'm-group',
                    id: group.modelId
                },
                mods: {
                    suggestions: this.ctx.showSuggestions ? 'on' : 'off'
                },
                group: group
            }
        ])
    };
});
