block('b-edit-group').elem('word-suggestions').def()(function() {
    var ctx = this.ctx;

    return {
        mixes: {
            row: [
                {
                    block: 'b-edit-group',
                    elem: 'row'
                },
                {
                    block: 'b-group-add-phrases',
                    modelParams: {
                        name: this.ctx.modelName || 'm-group',
                        id: this.group.modelId
                    },
                    mix: [{
                        block: 'b-group-add-phrases',
                        elem: 'new'
                    }],
                    banner: this.group,
                    mods: {
                        suggestions: this.ctx.showSuggestions ? 'on' : 'off'
                    },
                    js: {
                        id: 'new_phrases_' + this.group.modelId,
                        adgroupId: this.group.modelId,
                        modelParams: {
                            name: this.ctx.modelName || 'm-group',
                            id: this.group.modelId
                        }
                    }
                }
            ],
            label: [{
                block: 'b-edit-group',
                elem: 'label'
            }],
            info: [{
                block: 'b-edit-group',
                elem: 'info'
            }],
            control: [{
                block: 'b-edit-group',
                elem: 'control'
            }]
        },
        label: applyCtx({
            block: 'b-model-form-error',
            mix: [{
                block: 'b-model-form-error',
                elem: 'label'
            }],
            modelParams: {
                name: this.ctx.modelName || 'm-group',
                id: this.group.modelId
            },
            field: 'new_phrases',
            errors: this.ctx.errors,
            cutText: true,
            content: {
                block: 'b-group-add-phrases',
                elem: 'new-label',
                content: [
                    iget2('b-edit-group', 'novye-klyuchevye-frazy', 'Новые ключевые фразы'),
                    {
                        block: 'b-help-link',
                        mods: {
                            type: 'modal'
                        },
                        stretched: true,
                        mix: [{
                            block: 'b-edit-group',
                            elem: 'help-icon'
                        }],
                        url: u.getHelpUrl(ctx.helpLinkId || 'add-keywords'),
                        title: iget2('b-edit-group', 'kak-pravilno-podbirat-klyuchevye', 'Как правильно подбирать ключевые фразы?')
                    }
                ]
            }
        }),
        control: applyCtx([
            {
                block: 'b-model-form-error',
                mix: [{
                    block: 'b-model-form-error',
                    elem: 'control'
                }],
                modelParams: {
                    name: this.ctx.modelName || 'm-group',
                    id: this.group.modelId
                },
                field: 'new_phrases',
                errors: this.ctx.errors,
                cutText: iget2('b-edit-group', 'oshibki-v-zapolnenii-polya', 'Ошибки в заполнении поля "Ключевые фразы"')
            },
            {
                block: 'button',
                mods: {
                    pseudo: 'yes'
                },
                mix: [{
                    block: 'b-group-add-phrases',
                    elem: 'suggestions-toggler'
                }],
                content: iget2('b-edit-group', 'pokazat-podskazki', 'Показать подсказки')
            },
            {
                block: 'b-outboard-controls',
                js: {
                    id: 'wordstat-control'
                },
                content: {
                    elem: 'switcher',
                    js: {
                        innerBlockParams: {
                            adgroupId: this.group.modelId,
                            modelName: this.ctx.modelName
                        }
                    },
                    switcher: {
                        block: 'button',
                        mods: {
                            theme: 'normal'
                        },
                        mix: [{
                            block: 'b-outboard-controls',
                            elem: 'switcher-button'
                        }],
                        content: iget2('b-edit-group', 'podobrat-slova', 'Подобрать слова')
                    }
                }
            },
            {
                block: 'b-group-add-phrases',
                elem: 'content-wrapper',
                elemMods: {
                    suggestions: this.ctx.showSuggestions ? 'on' : 'off'
                },
                modelParams: {
                    name: this.ctx.modelName || 'm-group',
                    id: this.group.modelId
                },
                group: this.ctx.group
            }
        ])
    };
});
