block('b-edit-group').mod('type', 'dynamic-full')(

    mode('setModel')(function() {
        var group = this.ctx.group;

        group.data_source = !+group.feed_id ? 'domain' : 'feed';

        if (!group.group_name) group.group_name = iget2('b-edit-group', 'novaya-gruppa-obyavleniy', 'Новая группа объявлений');

        this.campaign = this.ctx.campaign;
        this.groupModelName = 'dm-dynamic-group';
        this.bannerModelName = 'dm-dynamic-banner';
        this.group = group;
        this.isSingleGroup = this.ctx.isSingleGroup;
        this.firstBanner = this.ctx.firstBanner;
        this.prevBanner = this.ctx.prevBanner;
        this.feeds = this.ctx.feeds;
        this.errors = group.errors || {};
        this.groupIndex = this.ctx.groupIndex;
        this.groupId = this.group.modelId;
        this.promoCodeDomains = this.data.promocode_domains;
    }),

    addMix()(function() {
        return [
            {
                block: 'i-glue',
                js: {
                    modelParams: {
                        name: this.groupModelName,
                        id: this.groupId
                    }
                }
            },
            {
                block: 'i-glue',
                elem: 'model-field',
                js: {
                    name: 'data_source',
                    type: 'mod',
                    modName: 'source',
                    block: 'b-edit-group'
                }
            },
            {
                block: 'b-edit-group',
                mods: {
                    source: this.group.data_source
                }
            }
        ];
    }),

    js()(function() {
        return {
            modelName: this.groupModelName,
            modelId: this.groupId,
            cid: this.data.campaign.cid,
            newBannerData: {
                hasHeaderActions: true,
                withVCard: this.group.withVCard,
                canEditDomain: this.ctx.canEditDomain,
                isCopyGroup: this.ctx.isCopyGroup,
                isNewGroup: this.ctx.isNewGroup,
                isSingleGroup: this.ctx.isSingleGroup
            },
            withMobile: false,
            errorPath: this.ctx.errorPath,
            showRegionsPopup: this.data.FORM.showRegionsPopup,
            promoCodeDomains: this.promoCodeDomains
        };
    }),

    elem('group-data').content()(function() {
        return {
            block: 'i-model-aggregator',
            content: [
                applyNext(),
                {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-adjustment-rates',
                        id: this.group.modelId,
                        data: this.group.hierarchicalMultipliers
                    }
                }
            ]
        };
    }),

    content()(function() {
        var data = this.data,
            group = this.group,
            canSelectDataSource = this.isCopyGroup || this.isNewGroup,
            groupContentBanners = [
                {
                    block: 'b-edit-group',
                    elem: 'rename-group',
                    elemMods: {
                        type: 'error2'
                    },
                    helpText: iget2(
                        'b-edit-group',
                        'v-gruppe-vy-mozhete-110',
                        'В группе вы можете создать одно или несколько объявлений с общими условиями показа'
                    )
                },
                {
                    block: 'b-edit-group',
                    elem: 'data-source',
                    elemMods: {
                        disabled: !canSelectDataSource ? 'yes' : ''
                    }
                },
                {
                    block: 'b-edit-group',
                    elem: 'url-params'
                },
                group.banners.map(function(banner, index) {
                    return {
                        block: 'b-edit-banner2',
                        mods: {
                            type: 'dynamic'
                        },
                        banner: banner,
                        urlLengthLimit: u.consts('MAX_URL_LENGTH'),
                        //если новый, не первый баннер в группе
                        canDelete: banner.bid == 0 && index > 0,
                        index: index,
                        campaign: data.campaign,
                        new_banner: data.new_banner,
                        hasHeaderActions: true,
                        group: group,
                        withVCard: true,
                        canEditDomain: this.ctx.canEditDomain,
                        isCopyGroup: group.isCopyGroup,
                        isSingleGroup: group.isSingleGroup,
                        errorPath: this.errorPath('banners[' + index + ']'),
                        promoCodeDomains: data.promocode_domains
                    };
                }, this)
            ],
            groupContentBannerGroup = [
                {
                    control: {
                        block: 'b-edit-group',
                        attrs: {
                            id: 'Group-properties-' + this.group.modelId
                        },
                        elem: 'group-properties',
                        content: iget2('b-edit-group', 'nastroyki-na-vsyu-gruppu', 'Настройки на всю группу')
                    }
                },
                //можем выбирать источник данных или задан в качестве источника данных домен
                !!(canSelectDataSource || this.group.main_domain) && {
                    block: 'b-edit-group',
                    elem: 'dynamic-conditions',
                    currCode: data.campaign.currency,
                    conditions: this.group.main_domain && this.group.dynamic_conditions &&
                        this.group.dynamic_conditions.length ?
                            this.group.dynamic_conditions :
                            data.campaign.default_dynamic_conditions &&
                                data.campaign.default_dynamic_conditions.by_domain || [],
                    currency: u.currencies.getName(data.campaign.currency),
                    strategy: data.campaign.strategy,
                    errorPath: this.errorPath('dynamic_conditions')
                },
                //можем выбирать источник данных или задан в качестве источника feed_id
                !!(canSelectDataSource || this.group.feed_id) && {
                    block: 'b-edit-group',
                    elem: 'feed-filters',
                    groupModelParam: {
                        name: this.groupModelName,
                        id: this.groupId
                    },
                    filters: this.group.feed_id && this.group.dynamic_conditions &&
                        this.group.dynamic_conditions.length ?
                            this.group.dynamic_conditions :
                            data.campaign.default_dynamic_conditions &&
                                data.campaign.default_dynamic_conditions.by_feed || [],
                    errorPath: this.errorPath('dynamic_conditions')
                },
                {
                    block: 'b-edit-group',
                    elem: 'minus-words',
                    elemMods: {
                        type: 'error2'
                    }
                },
                {
                    block: 'b-edit-group',
                    elem: 'regions',
                    elemMods: {
                        type: 'error2'
                    }
                },
                {
                    elem: 'adjustment-rates',
                    modelData: group.hierarchicalMultipliers,
                    tabsHash: u['b-adjustment-rates-popup'].getTabsHash({
                        hasRetargetingConditions: u.retargeting.hasRetargetingConditions(
                            this.data.all_retargeting_conditions,
                            'metrika_goals'
                        ),
                        demography: true,
                        mobile: true,
                        devices: hasEnabledFeatures('cpc_device_modifiers') || u.consts('isMobileOsBidModifierEnabled'),
                        video: false,
                        retargeting: true,
                        performanceTGO: false
                    })
                },
                this.data.tags_allowed == 'Yes' && {
                    elem: 'tags2',
                    tagsController: {
                        block: 'b-group-tags2-controller',
                        js: {
                            modelParams: {
                                group: {
                                    name: this.groupModelName,
                                    id: this.groupId
                                },
                                campaign: {
                                    name: 'm-campaign',
                                    id: this.data.campaign.cid
                                }
                            }
                        }
                    },
                    tags: u.groupTags2.makeTagsArray(data.campaign.tags || [], group.tags || {}),
                    errorPath: this.errorPath('tags')
                }
            ];

        return [
            applyNext(),
            apply('editLayout', {
                group: group,
                mix: {
                    block: 'b-edit-group',
                    elem: 'banners-wrapper'
                },
                groupContent: groupContentBanners
            }),
            apply('editLayout', {
                group: group,
                groupContent: [{
                    block: 'b-edit-group',
                    elem: 'add-banner-button',
                    elemMods: {
                        type: 'new-error-display'
                    },
                    availableToCreateBannersCount: u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - group.banners_quantity,
                    mainTitle: iget2('b-edit-group', 'dobavit-obyavlenie', 'Добавить объявление'),
                    pluralTitles: [iget2('b-edit-group', 'obyavlenie-111', 'объявление'), iget2('b-edit-group', 'obyavleniya', 'объявления'), iget2('b-edit-group', 'obyavleniy', 'объявлений')],
                    errorPath: this.errorPath('banners')
                }]
            }),
            apply('editLayout', {
                mix: {
                    block: 'b-edit-group',
                    elem: 'grey-wrapper'
                },
                group: group,
                groupContent: groupContentBannerGroup
            })
        ];
    })
);
