/**
 * @listens b-feed-filter#filter:edit:completed
 * @fires b-feed-filter#filter:edit:completed
 */
BEM.DOM.decl({ block: 'b-edit-group', modName: 'type', modVal: 'dynamic-full' }, {
    /**
     * @override {b-edit-group}
     */
    _onBeforeBannerAdd: function(bannerModel) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') + 1);
    },

    /**
     * @override {b-edit-group}
     */
    _onBeforeBannerRemove: function(bannerId) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') - 1);
    },

    /**
     * @override {b-edit-group}
     */
    _getAvailableToCreateBannersCount: function() {
        return u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - this.model.get('banners_quantity');
    },

    /**
     * Инициализирует проверку промокодов для поля "Сайт" у группы
     * @private
     */
    _initPromoCodeDomainsChecker: function() {
        var promoCodeDomains;

        if (this.params.promoCodeDomains === undefined || this.params.promoCodeDomains.length === 0) {
            return;
        }

        promoCodeDomains = this.params.promoCodeDomains.map(function(domain) {
            return domain.toLowerCase();
        });

        this.model.on('main_domain', 'change', function() {
            var currentValue = this.model.get('main_domain').toLowerCase().trim(),
                isPromoCodeDomain = u._.includes(promoCodeDomains, currentValue);

            this.setMod(this.elem('promo-code-warning'), 'hidden', isPromoCodeDomain || currentValue === '' ? 'yes' : '');
        }, this);
    },

    /**
     * @override {b-edit-group}
     */
    _additionalInit: function() {
        //если есть опция выбора источника данных или был ранее выбран источник данных "Фид" - инициализируем контролы для фидов
        (this.model.get('canSelectDataSource') || this.model.get('data_source') === 'feed') && this._initFeeds();

        this.model.get('canSelectDataSource') &&
            this.findBlockInside('switch-source', 'radio-button').setMod('disabled', '');

        this._feedFilters = this.findBlockOn('filters', 'b-feed-filters');

        if (this._feedFilters) {
            this._getSubscriptionManager().on(this._feedFilters, 'filter:edit:completed', function(e, data) {
                this.trigger('filter:edit:completed', data);
            }.bind(this));
        }

        this._initPromoCodeDomainsChecker();
    },

    /**
     * @override {b-edit-group}
     */
    _getEditBlockBemjson: function(bannerModel) {
        var bannerData = bannerModel.provideData();

        return u._.extend({}, this.params.newBannerData, {
            block: 'b-edit-banner2',
            mods: { type: 'dynamic' },
            canDelete: true,
            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
            banner: bannerData,
            group: u._.extend(this.model.provideData(), { modelId: this.model.id }),
            campaign: this.model.getCampaignModel().toJSON(),
            noModelData: true,
            withVCard: true,
            errorPath: this._errorPathBuilder(this.model.get('banners_quantity') - 1) // используем banners_quantity,
                                                                                      // чтобы получить порядковый
                                                                                      // номер нового баннера
        });
    }
});
