block('b-edit-group').mod('type', 'dynamic-media-full')(

    mode('setModel')(function() {
        var group = this.ctx.group,
            data = this.data;

        if (!group.group_name) group.group_name = iget2('b-edit-group', 'novaya-gruppa-bannerov', 'Новая группа баннеров');

        this.campaign = this.ctx.campaign;
        this.groupModelName = 'dm-dynamic-media-group';
        this.group = group;
        this.feeds = this.ctx.feeds;
        this.isSingleGroup = this.ctx.isSingleGroup;
        this.isCopyGroup = !!data.is_groups_copy_action;
        this.firstBanner = this.ctx.firstBanner;
        this.prevBanner = this.ctx.prevBanner;
        this.errors = group.errors || {};
        this.groupIndex = this.ctx.groupIndex;
        this.groupId = this.group.modelId;
        this.ulogin = data.FORM.ulogin;
    }),

    js()(function() {
        return {
            modelName: this.groupModelName,
            modelId: this.groupId,
            cid: this.data.campaign.cid,
            newBannerData: {
                hasHeaderActions: true,
                isCopyGroup: this.ctx.isCopyGroup,
                isNewGroup: this.ctx.isNewGroup,
                isSingleGroup: this.ctx.isSingleGroup
            },
            showRegionsPopup: this.data.FORM.showRegionsPopup
        };
    }),

    elem('group-data').content()(function() {
        return {
            block: 'i-model-aggregator',
            content: [
                applyNext(),
                {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-adjustment-rates',
                        id: this.group.modelId,
                        data: this.group.hierarchicalMultipliers
                    }
                }
            ]
        };
    }),

    content()(function() {
        var data = this.data,
            group = this.group,
            groupContentBanners = [
                {
                    block: 'b-edit-group',
                    elem: 'rename-group',
                    elemMods: {
                        type: 'error2'
                    },
                    headerType: 'performance',
                    helpText: iget2(
                        'b-edit-group',
                        'v-gruppe-vy-mozhete-112',
                        'В группе вы можете создать один или несколько баннеров с общими условиями показа'
                    )
                },
                {
                    block: 'b-edit-group',
                    elem: 'feed',
                    elemMods: {
                        type: 'performance'
                    }
                },
                {
                    block: 'b-edit-group',
                    elem: 'url-params'
                },
                {
                    block: 'b-edit-group',
                    elem: 'feed-field-for-name'
                },
                {
                    block: 'b-edit-group',
                    elem: 'feed-field-for-body'
                },
                {
                    block: 'b-edit-group',
                    elem: 'dynamic-media-creatives-list',
                    mix: {
                        block: 'i-list-style',
                        mods: {
                            style: 'decimal-outside'
                        }
                    },
                    content: {
                        block: 'b-edit-group',
                        elem: 'dynamic-media-creatives-list-items',
                        mix: {
                            block: 'i-list-style',
                            elem: 'items'
                        },
                        content: group.banners.map(function(banner) {
                            return [
                                {
                                    block: 'b-edit-banner2',
                                    mods: {
                                        type: 'dynamic-media'
                                    },
                                    mix: [
                                        {
                                            block: 'i-list-style',
                                            elem: 'item'
                                        },
                                        {
                                            block: 'b-edit-group',
                                            elem: 'banner-row',
                                            elemMods: {
                                                'banner-id': banner.modelId
                                            }
                                        }
                                    ],
                                    banner: banner,
                                    group: group
                                }
                            ];
                        })
                    }
                }
            ],
            groupContentBannerGroup = [
                {
                    control: {
                        block: 'b-edit-group',
                        attrs: {
                            id: 'Group-properties-' + this.group.modelId
                        },
                        elem: 'group-properties',
                        content: iget2('b-edit-group', 'nastroyki-na-vsyu-gruppu', 'Настройки на всю группу')
                    }
                },
                {
                    block: 'b-edit-group',
                    elem: 'feed-filters',
                    groupModelParam: {
                        name: this.groupModelName,
                        id: this.groupId
                    },
                    filters: this.group.performance_filters,
                    errorPath: this.errorPath('feed_filters')
                        // todo feed_filters->performance_filters в DIRECT-55706
                },
                {
                    block: 'b-edit-group',
                    elem: 'minus-words',
                    elemMods: {
                        type: 'error2'
                    }
                },
                {
                    block: 'b-edit-group',
                    elem: 'regions',
                    elemMods: {
                        type: 'error2'
                    }
                },
                {
                    block: 'b-edit-group',
                    elem: 'adjustment-rates',
                    modelData: group.hierarchicalMultipliers,
                    tabsHash: u['b-adjustment-rates-popup'].getTabsHash({
                        hasRetargetingConditions: u.retargeting.hasRetargetingConditions(
                            this.data.all_retargeting_conditions,
                            'metrika_goals'
                        ),
                        demography: true,
                        mobile: true,
                        devices: hasEnabledFeatures('cpc_device_modifiers'),
                        video: false,
                        retargeting: true,
                        performanceTGO: true
                    })
                },
                !!this.data.tags_allowed && {
                    block: 'b-edit-group',
                    elem: 'tags2',
                    tagsController: {
                        block: 'b-group-tags2-controller',
                        js: {
                            modelParams: {
                                group: {
                                    name: this.groupModelName,
                                    id: this.groupId
                                },
                                campaign: {
                                    name: 'dm-dynamic-media-campaign',
                                    id: this.data.campaign.cid
                                }
                            }
                        }
                    },
                    tags: u.groupTags2.makeTagsArray(data.campaign.tags || [], group.tags || {}),
                    errorPath: this.errorPath('tags')
                }
            ];

        return [
            applyNext(),
            apply('editLayout', {
                group: group,
                mix: {
                    block: 'b-edit-group',
                    elem: 'banners-wrapper'
                },
                groupContent: groupContentBanners
            }),
            apply('editLayout', {
                group: group,
                groupContent: [{
                    block: 'b-edit-group',
                    elem: 'add-banner-button',
                    elemMods: {
                        type: 'dynamic'
                    },
                    feedId: group.feed_id,
                    mainTitle: iget2('b-edit-group', 'dobavit-banner', 'Добавить баннер'),
                    pluralTitles: [iget2('b-edit-group', 'banner-113', 'баннер'), iget2('b-edit-group', 'bannera', 'баннера'), iget2('b-edit-group', 'bannerov', 'баннеров')],
                    availableToCreateBannersCount: group.feed_id ?
                        (u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - group.banners_quantity) :
                        0,
                    errorPath: this.errorPath('banners')
                }]
            }),
            apply('editLayout', {
                mix: {
                    block: 'b-edit-group',
                    elem: 'grey-wrapper'
                },
                group: group,
                groupContent: groupContentBannerGroup
            })
        ];
    })
);
