/**
 * @listens b-feed-filter#filter:edit:completed
 * @fires b-feed-filter#filter:edit:completed
 */
BEM.DOM.decl({ block: 'b-edit-group', modName: 'type', modVal: 'dynamic-media-full' }, {
    _additionalInit: function() {
        this._page = BEM.blocks['b-page'].getInstance();

        this._getSubscriptionManager().wrap(BEM.blocks['b-edit-banner2'])
            .on(this.domElem, 'edit', function(e, data) {
                this._editBanner(data.modelId);
            }, this);

        this._initFeeds();

        this._feedFilters = this.findBlockOn('filters', 'b-feed-filters');

        if (this._feedFilters) {
            this._getSubscriptionManager().on(this._feedFilters, 'filter:edit:completed', function(e, data) {
                this.trigger('filter:edit:completed', data);
            }.bind(this));
        }

        this._initFeedTextAsNameControls();
        this._initFeedTextAsBodyControls();
    },

    _initFeedTextAsNameControls: function() {
        var feedTitlesCache = {};

        this._feedTextAsNameControls = this.findBlockOn('feed-field-for-name', 'b-group-feed-field-for-name');

        this._getSubscriptionManager().on(this._feedTextAsNameControls, 'change', function(event, data) {
            this.model.update({
                feedFieldForName: {
                    isChecked: data.isChecked,
                    value: data.value
                }
            });
        }, this);

        // при смене фида старое значение сохраняем, при переключении снова на фид показываем
        this._getSubscriptionManager().on(this._feed, 'change', function(e, data) {
            var feedTextAsNameControlsValue = this._feedTextAsNameControls.getValue();

            feedTitlesCache[data.prev_feed_id] = feedTextAsNameControlsValue.isChecked ?
                feedTextAsNameControlsValue.value :
                undefined;

            if (feedTitlesCache[data.feed_id]) {
                this._feedTextAsNameControls.setValue({
                    isChecked: true,
                    value: feedTitlesCache[data.feed_id]
                });
            } else {
                this._feedTextAsNameControls.setValue({
                    isChecked: false,
                    value: ''
                });
            }
        }, this);
    },

    _initFeedTextAsBodyControls: function() {
        var feedBodiesCache = {};

        this._feedTextAsBodyControls = this.findBlockOn('feed-field-for-body', 'b-group-feed-field-for-body');

        this._getSubscriptionManager().on(this._feedTextAsBodyControls, 'change', function(event, data) {
            this.model.update({
                feedFieldForBody: {
                    isChecked: data.isChecked,
                    value: data.value
                }
            });
        }, this);

        // при смене фида старое значение сохраняем, при переключении снова на фид показываем
        this._getSubscriptionManager().on(this._feed, 'change', function(e, data) {
            var feedTextAsBodyControlsValue = this._feedTextAsBodyControls.getValue();

            feedBodiesCache[data.prev_feed_id] = feedTextAsBodyControlsValue.isChecked ?
                feedTextAsBodyControlsValue.value :
                undefined;

            if (feedBodiesCache[data.feed_id]) {
                this._feedTextAsBodyControls.setValue({
                    isChecked: true,
                    value: feedBodiesCache[data.feed_id]
                });
            } else {
                this._feedTextAsBodyControls.setValue({
                    isChecked: false,
                    value: ''
                });
            }
        }, this);
    },

    /**
     * @override {b-edit-group}
     */
    _getAvailableToCreateBannersCount: function() {
        return u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - this.model.get('banners').length();
    },

    /**
     * @override {b-edit-group}
     */
    _onBannerAddRequest: function() {
        this._showAddBannersPopup();
    },

    /**
     * Возвращает попап редактирования/добавления баннеров
     * @returns {BEM}
     */
    _getPopup: function(contentJson, onSaveSuccess) {
        var popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator'].create2({ adaptive: 'yes' }, {}, $),
            creativeChooseSubscriptionManager = BEM.create('i-subscription-manager'),
            groupCreativesPopup = popupDecorator.setPopupContent(contentJson);

        creativeChooseSubscriptionManager
            .on(groupCreativesPopup, 'cancel', function() {
                popupDecorator.hide()
            }, this)
            .on(popupDecorator, 'close', function() {
                creativeChooseSubscriptionManager.dispose();
                creativeChooseSubscriptionManager.destruct();

                popupDecorator.destruct();
            }, this)
            .on(groupCreativesPopup, 'limitExceeded', function(e, data) {
                BEM.blocks['b-confirm'].alert(
                    u.pluralForms(
                        iget2(
                            'b-edit-group',
                            'v-gruppu-mozhno-dobavit',
                            'В группу можно добавить еще {foo} {баннер|баннера|баннеров}. Выбрано {bar}. Уменьшите количество добавляемых баннеров и повторите попытку.',
                            {
                                foo: data.limit,
                                bar: data.actual
                            }
                        ),
                        data.limit,
                        data.actual)
                );
            }, this)
            .on(groupCreativesPopup, 'save', function(e, data) {
                onSaveSuccess(e, data);
                popupDecorator.hide({ force: true });
            }, this)
            .on(popupDecorator, 'close-blocked', function() {
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-edit-group', 'izmeneniya-ne-budut-sohraneny', 'Изменения не будут сохранены. Продолжить?'),
                    fromPopup: popupDecorator.getPopup(),
                    onYes: function() {
                        popupDecorator.hide({ force: true });
                    }
                });
            }, this);

        popupDecorator.getPopup().setMod('for', 'choose-creative');

        return popupDecorator;
    },

    /**
     * Отображает попап добавления новых баннеров
     */
    _showAddBannersPopup: function() {
        var feedId = this.model.get('feed_id'),
            businessType = BEM.MODEL.getOne({ name: 'dm-dynamic-media-feed', id: feedId }).get('business_type');

        this._getPopup({
            block: 'b-dynamic-media-creatives-choose',
            mods: { type: 'add' },
            ulogin: u.consts('ulogin'),
            limit: u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - this.model.get('banners').length(),
            exclude: {
                creativeIds: this.model.getUsedCreativeIds()
            },
            filters: [{ filter: 'business_type', value: businessType }]
        },
            function(e, selected) {
                selected.length && selected.forEach(function(creativeData) {
                    var newBannerModel = this.model.addBanner(creativeData);

                    this._addBanner(newBannerModel);
                }, this);
            }.bind(this)
        ).show();
    },

    /**
     * Отображает попапа редактирования баннера
     * @param {String} bannerId идентификатор редактируемого баннера
     */
    _editBanner: function(bannerId) {
        var feedId = this.model.get('feed_id'),
            editedBanner = BEM.MODEL.getOne({ name: 'dm-dynamic-media-banner', id: bannerId }),
            businessType = BEM.MODEL.getOne({ name: 'dm-dynamic-media-feed', id: feedId }).get('business_type');

        this._getPopup({
            block: 'b-dynamic-media-creatives-choose',
            mods: { type: 'edit' },
            ulogin: u.consts('ulogin'),
            currentBannerId: editedBanner.get('creative').get('creative_id'),
            exclude: {
                creativeIds: this.model.getUsedCreativeIds()
            },
            filters: [{ filter: 'business_type', value: businessType }]
        },
            function(e, banner) {
                editedBanner.set('creative', banner);
            }
        ).show();
    },

    /**
     * @override {b-edit-group}
     */
    _onBannerRemoveRequest: function(bannerId) {
        var bannerToRemove = BEM.MODEL.getOne({ name: 'dm-dynamic-media-banner', id: bannerId }),
            isBannerChanged = bannerToRemove.isChanged(),
            doRemove = this._removeBanner.bind(this, bannerId);

        this.model.removeBanner(bannerId);

        if (isBannerChanged) {
            BEM.blocks['b-confirm'].open({
                message: iget2('b-edit-group', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить объявление?'),
                onYes: doRemove
            }, this);
        } else {
            doRemove();
        }
    },

    /**
     * @override {b-edit-group}
     */
    _getEditBlockBemjson: function(bannerModel) {
        var bannerData = bannerModel.provideData();

        return {
            block: 'b-edit-banner2',
            mods: { type: 'dynamic-media' },
            mix: [
                { block: 'i-list-style', elem: 'item' },
                { block: 'b-edit-group', elem: 'banner-row', elemMods: { 'banner-id': bannerData.modelId } }
            ],
            banner: bannerData,
            group: this.model.toJSON()
        };
    },

    /**
     * @override {b-edit-group}
     */
    _buildBannerRow: function(bannerModel) {
        return BEMHTML.apply(this._getEditBlockBemjson(bannerModel));
    },

    /**
     * @override {b-edit-group}
     */
    _getBannersListContainer: function() {
        return this.elem('dynamic-media-creatives-list-items');
    }
});
