block('b-edit-group').mod('type', 'mcbanner')(

    mode('setModel')(function() {
        var group = this.ctx.group;

        if (!group.group_name) group.group_name = iget2('b-edit-group', 'novaya-gruppa-bannerov', 'Новая группа баннеров');

        this.groupModelName = 'dm-mcbanner-group';
        this.group = group;
        this.isSingleGroup = this.ctx.isSingleGroup;
        this.firstBanner = this.ctx.firstBanner;
        this.prevBanner = this.ctx.prevBanner;
        this.errors = group.errors || {};
        this.groupIndex = this.ctx.groupIndex;
        this.groupId = this.group.modelId;
        this.campaign = this.ctx.campaign;
    }),

    elem('group-data').content()(function() {
        var group = this.group;

        return {
            block: 'i-model-aggregator',
            content: [
                applyNext(),
                {
                    block: 'i-model',
                    modelParams: {
                        name: 'm-adjustment-rates',
                        id: group.modelId,
                        data: group.hierarchicalMultipliers
                    }
                }
            ]
        };
    }),

    content()(function() {
        var data = this.data,
            campaign = this.campaign,
            group = this.group,
            availableCount = data.CONSTS.DEFAULT_CREATIVE_COUNT_LIMIT - 1 * group.banners_quantity,
            sortedPhrases = group.sorted.phrases,
            // блок с подсказками показываем только если мы на редактировании одной группы
            showSuggestions = this.data.campaign.groups.length == 1,
            hasPhrases = sortedPhrases &&
            (sortedPhrases.declined.length ||
                sortedPhrases.low_ctr.length ||
                sortedPhrases.context.length ||
                sortedPhrases.suspended.length ||
                sortedPhrases.active.length),
            groupContentBanners = [
                {
                    block: 'b-edit-group',
                    elem: 'rename-group',
                    elemMods: {
                        type: 'error2'
                    },
                    headerType: 'mcbanner',
                    helpText: iget2(
                        'b-edit-group',
                        'v-gruppe-vy-mozhete-114',
                        'В группе вы можете создать один или несколько баннеров с общим набором ключевых фраз и едиными условиями показа'
                    )
                },
                group.banners.map(function(banner, index) {
                    banner.status_click_track = campaign.status_click_track;

                    return {
                        block: 'b-edit-banner2',
                        mods: { type: 'mcbanner' },
                        mix: [{
                            block: 'b-edit-group',
                            elem: 'banner-row',
                            elemMods: {
                                'banner-id': banner.modelId
                            }
                        }],
                        banner: banner,
                        urlLengthLimit: u.consts('MAX_URL_LENGTH'),
                        //если новый, не первый баннер в группе
                        canDelete: banner.bid == 0 && index > 0,
                        index: index,
                        campaign: data.campaign,
                        new_banner: data.new_banner,
                        hasHeaderActions: true,
                        group: group,
                        availableBannerCount: availableCount,
                        canEditDomain: this.ctx.canEditDomain,
                        isCopyGroup: group.isCopyGroup,
                        isNewOrCopyGroup: group.isNewGroup,
                        isSingleGroup: group.isSingleGroup,
                        errorPath: this.errorPath('banners[' + index + ']')
                    };
                }, this)
            ],
            groupContentBannerGroup = [
                {
                    control: {
                        block: 'b-edit-group',
                        attrs: {
                            id: 'Group-properties-' + this.group.modelId
                        },
                        elem: 'group-properties',
                        content: iget2('b-edit-group', 'nastroyki-na-vsyu-gruppu', 'Настройки на всю группу')
                    }
                },
                hasPhrases && {
                    block: 'b-edit-group',
                    elem: 'phrases',
                    elemMods: {
                        type: 'error2'
                    },
                    modelName: 'dm-mcbanner-group'
                },
                {
                    block: 'b-edit-group',
                    elem: 'new-phrases',
                    elemMods: {
                        type: 'error2'
                    },
                    showSuggestions: showSuggestions,
                    modelName: 'dm-mcbanner-group'
                },
                {
                    block: 'b-edit-group',
                    elem: 'word-suggestions',
                    elemMods: {
                        type: 'error2'
                    },
                    group: group,
                    errorPath: this.errorPath('keywords'),
                    showSuggestions: showSuggestions,
                    modelName: 'dm-mcbanner-group',
                    helpLinkId: 'add-keywords-search'
                },
                {
                    block: 'b-edit-group',
                    elem: 'minus-words',
                    elemMods: {
                        type: 'error2'
                    },
                    modelName: 'dm-mcbanner-group'
                },
                {
                    block: 'b-edit-group',
                    elem: 'regions',
                    elemMods: {
                        type: 'error2'
                    },
                    parentModelName: 'dm-mcbanner-group'
                },
                group.has_general_limit_price && {
                    block: 'b-edit-group',
                    elem: 'limit-rate',
                    campDMParams: {
                        name: 'm-campaign'
                    },
                    modelParams: {
                        name: 'dm-mcbanner-group',
                        id: group.modelId
                    },
                    currency: data.campaign.currency,
                    helpLinkId: 'maximum-bid-search'
                },
                {
                    elem: 'adjustment-rates',
                    modelData: group.hierarchicalMultipliers,
                    tabsHash: u['b-adjustment-rates-popup'].getTabsHash({
                        hasRetargetingConditions: u.retargeting.hasRetargetingConditions(
                            this.data.all_retargeting_conditions,
                            'metrika_goals'
                        ),
                        demography: true,
                        retargeting: true,
                        performanceTGO: false
                    }),
                    helpLinkId: 'bids-adjustment-search'
                },
                this.data.tags_allowed == 'Yes' && {
                    block: 'b-edit-group',
                    elem: 'tags2',
                    tagsController: {
                        block: 'b-group-tags2-controller',
                        js: {
                            modelParams: {
                                group: {
                                    name: this.groupModelName,
                                    id: this.groupId
                                },
                                campaign: {
                                    name: 'm-campaign',
                                    id: this.data.campaign.cid
                                }
                            }
                        }
                    },
                    tags: u.groupTags2.makeTagsArray(data.campaign.tags || [], group.tags || {}),
                    errorPath: this.errorPath('tags')
                }
            ];

        return [
            applyNext(),
            apply('editLayout',{
                group: group,
                mix: {
                    block: 'b-edit-group',
                    elem: 'banners-wrapper'
                },
                groupContent: groupContentBanners
            }),
            apply('editLayout', {
                group: group,
                groupContent: [{
                    block: 'b-edit-group',
                    elem: 'add-banner-button',
                    elemMods: {
                        type: 'new-error-display'
                    },
                    availableToCreateBannersCount: u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - group.banners_quantity,
                    mainTitle: iget2('b-edit-group', 'dobavit-banner', 'Добавить баннер'),
                    pluralTitles: [iget2('b-edit-group', 'banner-113', 'баннер'), iget2('b-edit-group', 'bannera', 'баннера'), iget2('b-edit-group', 'bannerov', 'баннеров')],
                    errorPath: this.errorPath('banners')
                }]
            }),
            apply('editLayout', {
                mix: {
                    block: 'b-edit-group',
                    elem: 'grey-wrapper'
                },
                group: group,
                groupContent: groupContentBannerGroup
            })
        ];
    })
);
