BEM.DOM.decl({ name: 'b-edit-group', modName: 'type', modVal: 'mcbanner' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._initGeneralLimitPrice(this.model);
        }
    },

    /**
     * @override {b-edit-group}
     */
    _getNewBannerModel: function(defaults) {
        var newBannerData = u._.extend({}, defaults);

        return this.model.addBanner(newBannerData);
    },

    /**
     * @override {b-edit-group}
     */
    _onBeforeBannerAdd: function(bannerModel) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') + 1);
    },

    /**
     * @override {b-edit-group}
     */
    _onBeforeBannerRemove: function(bannerId) {
        this.model.set('banners_quantity', this.model.get('banners_quantity') - 1);
    },

    /**
     * @override {b-edit-group}
     */
    _getAvailableToCreateBannersCount: function() {
        return u.consts('DEFAULT_CREATIVE_COUNT_LIMIT') - this.model.get('banners_quantity');
    },

    /**
     * @override {b-edit-group}
     */
    _updateCountInBlocks: function(available) {
        this._banners
            .forEach(function(banner) {
                banner.updateAvailableBannerCount(available);
            });
    },

    /**
     * @override {b-edit-group}
     */
    _getEditBlockBemjson: function(bannerModel) {
        var bannerData = bannerModel.provideData();

        return u._.extend({}, this.params.newBannerData, {
            block: 'b-edit-banner2',
            mods: { type: 'mcbanner' },
            canDelete: true,
            urlLengthLimit: u.consts('MAX_URL_LENGTH'),
            banner: bannerData,
            group: u._.extend(this.model.provideData(), { modelId: this.model.id }),
            campaign: this.model.getCampaignModel().toJSON(),
            noModelData: true,
            modelParams: {
                name: bannerModel.name,
                id: bannerModel.id,
                parentModel: this.model
            },
            availableBannerCount: this._getAvailableToCreateBannersCount(),
            errorPath: this._errorPathBuilder(this.model.get('banners_quantity') - 1) // визуальные индексы на 1 больше индексов для ошибок
        });
    }
});
